/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.saplings;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;

public abstract class SaplingBlock
extends BlockSapling {
    private final boolean growsInDark;
    private final float growthTimeModifier;
    private boolean completedInitialConstruct = false;

    public SaplingBlock(String name, String registryName) {
        this(name, registryName, false, 1.0f);
    }

    public SaplingBlock(String name, String registryName, boolean growsInDark) {
        this(name, registryName, growsInDark, 1.0f);
    }

    public SaplingBlock(String name, String registryName, boolean growsInDark, float growthTimeModifier) {
        this.func_149663_c(name);
        this.setRegistryName("aoa3:" + registryName);
        this.func_149711_c(0.0f);
        this.func_149752_b(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabsRegister.DECORATION_BLOCKS);
        ObfuscationReflectionHelper.setPrivateValue(Block.class, (Object)((Object)this), (Object)new BlockStateContainer((Block)this, new IProperty[0]), (String)"field_176227_L");
        this.func_180632_j(this.func_176194_O().func_177621_b());
        this.growsInDark = growsInDark;
        this.growthTimeModifier = growthTimeModifier;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            this.func_176475_e(world, pos, state);
            if (!world.func_175697_a(pos, 1)) {
                return;
            }
            if (rand.nextInt((int)Math.pow(7.0f * this.growthTimeModifier, 2.0)) == 0 && (this.growsInDark || world.func_175671_l(pos.func_177984_a()) >= 9)) {
                this.func_176474_b(world, rand, pos, state);
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this));
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return (double)world.field_73012_v.nextFloat() < Math.pow(Math.max(1.0E-4, 0.45 / (double)this.growthTimeModifier), 2.0);
    }

    public void func_176478_d(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.func_176474_b(worldIn, rand, pos, state);
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.func_176476_e(worldIn, pos, state, rand);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected boolean func_185514_i(IBlockState state) {
        return super.func_185514_i(state) || state.func_177230_c() instanceof BlockGrass || state.func_177230_c() instanceof BlockDirt;
    }

    protected BlockStateContainer func_180661_e() {
        if (!this.completedInitialConstruct) {
            this.completedInitialConstruct = true;
            return new BlockStateContainer((Block)this, new IProperty[]{field_176480_a, field_176479_b});
        }
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }

    public abstract void func_176476_e(World var1, BlockPos var2, IBlockState var3, Random var4);
}

