/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.utility;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.UnbreakableBlock;
import net.tslat.aoa3.capabilities.providers.AdventPlayerProvider;
import net.tslat.aoa3.entity.boss.coniferon.EntityConiferon;
import net.tslat.aoa3.entity.boss.goldorth.EntityGoldorth;
import net.tslat.aoa3.entity.boss.horon.EntityHoron;
import net.tslat.aoa3.entity.boss.penumbra.EntityPenumbra;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class AncientCavernShrine
extends UnbreakableBlock {
    private final Enums.Deities deity;

    public AncientCavernShrine(String name, String registryName, Enums.Deities deity) {
        super(name, registryName, Material.field_151576_e);
        this.deity = deity;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !player.func_70093_af() && world.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.ancientCavern && player.hasCapability(AdventPlayerProvider.ADVENT_PLAYER, null)) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
            BlockPos teleportPos = new BlockPos(0, 17, 0);
            switch (this.deity) {
                case EREBON: {
                    if (pos.func_177958_n() <= -20 && pos.func_177952_p() >= 60) break;
                    teleportPos = new BlockPos(-70, 18, 80);
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (plData.stats().getLevel(Enums.Skills.HUNTER) < 70) {
                            if (player instanceof EntityPlayerMP) {
                                PlayerUtil.notifyPlayerOfInsufficientLevel((EntityPlayerMP)player, Enums.Skills.HUNTER, 70);
                            }
                            return true;
                        }
                        if (plData.stats().getTribute(Enums.Deities.EREBON) < 200) {
                            if (player instanceof EntityPlayerMP) {
                                PlayerUtil.notifyPlayerOfInsufficientTribute((EntityPlayerMP)player, Enums.Deities.EREBON, 200);
                            }
                            return true;
                        }
                        plData.stats().addTribute(Enums.Deities.EREBON, -20);
                    }
                    EntityPenumbra penumbra = new EntityPenumbra(world);
                    penumbra.func_70012_b(-51.0, 18.0, 92.0, 0.0f, 0.0f);
                    world.func_72838_d((Entity)penumbra);
                    break;
                }
                case LUXON: {
                    if (pos.func_177958_n() >= 60 && pos.func_177952_p() <= -20) break;
                    teleportPos = new BlockPos(80, 18, -70);
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (plData.stats().getLevel(Enums.Skills.RUNATION) < 70) {
                            if (player instanceof EntityPlayerMP) {
                                PlayerUtil.notifyPlayerOfInsufficientLevel((EntityPlayerMP)player, Enums.Skills.RUNATION, 70);
                            }
                            return true;
                        }
                        if (plData.stats().getTribute(Enums.Deities.LUXON) < 200) {
                            if (player instanceof EntityPlayerMP) {
                                PlayerUtil.notifyPlayerOfInsufficientTribute((EntityPlayerMP)player, Enums.Deities.LUXON, 200);
                            }
                            return true;
                        }
                        plData.stats().addTribute(Enums.Deities.LUXON, -20);
                    }
                    EntityHoron horon = new EntityHoron(world);
                    horon.func_70012_b(80.0, 18.0, -70.0, 0.0f, 0.0f);
                    world.func_72838_d((Entity)horon);
                    break;
                }
                case PLUTON: {
                    if (pos.func_177958_n() >= 60 && pos.func_177952_p() >= 60) break;
                    teleportPos = new BlockPos(80, 18, 80);
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (plData.stats().getLevel(Enums.Skills.FORAGING) < 70) {
                            if (player instanceof EntityPlayerMP) {
                                PlayerUtil.notifyPlayerOfInsufficientLevel((EntityPlayerMP)player, Enums.Skills.FORAGING, 70);
                            }
                            return true;
                        }
                        if (plData.stats().getTribute(Enums.Deities.PLUTON) < 200) {
                            if (player instanceof EntityPlayerMP) {
                                PlayerUtil.notifyPlayerOfInsufficientTribute((EntityPlayerMP)player, Enums.Deities.PLUTON, 200);
                            }
                            return true;
                        }
                        plData.stats().addTribute(Enums.Deities.PLUTON, -20);
                    }
                    EntityGoldorth goldorth = new EntityGoldorth(world);
                    goldorth.func_70012_b(80.0, 18.0, 80.0, 0.0f, 0.0f);
                    world.func_72838_d((Entity)goldorth);
                    break;
                }
                case SELYAN: {
                    if (pos.func_177958_n() <= -20 && pos.func_177952_p() <= -20) break;
                    teleportPos = new BlockPos(-60, 18, -65);
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (plData.stats().getLevel(Enums.Skills.INFUSION) < 70) {
                            if (player instanceof EntityPlayerMP) {
                                PlayerUtil.notifyPlayerOfInsufficientLevel((EntityPlayerMP)player, Enums.Skills.INFUSION, 70);
                            }
                            return true;
                        }
                        if (plData.stats().getTribute(Enums.Deities.SELYAN) < 200) {
                            if (player instanceof EntityPlayerMP) {
                                PlayerUtil.notifyPlayerOfInsufficientTribute((EntityPlayerMP)player, Enums.Deities.SELYAN, 200);
                            }
                            return true;
                        }
                        plData.stats().addTribute(Enums.Deities.SELYAN, -20);
                    }
                    EntityConiferon coniferon = new EntityConiferon(world);
                    coniferon.func_70012_b(-60.0, 18.0, -65.0, 0.0f, 0.0f);
                    world.func_72838_d((Entity)coniferon);
                }
            }
            player.func_70634_a((double)teleportPos.func_177958_n(), (double)teleportPos.func_177956_o(), (double)teleportPos.func_177952_p());
        }
        return true;
    }
}

