/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.utility;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.tool.misc.InfusionBowl;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;
import net.tslat.aoa3.utils.skills.ExtractionUtil;

public class ExtractionDevice
extends Block {
    private final boolean full;

    public ExtractionDevice(boolean full) {
        super(Material.field_151576_e);
        this.full = full;
        this.func_149663_c(full ? "ExtractionDeviceOn" : "ExtractionDevice");
        this.setRegistryName("aoa3:" + (full ? "extraction_device_on" : "extraction_device"));
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149675_a(true);
        if (!full) {
            this.func_149647_a(CreativeTabsRegister.FUNCTIONAL_BLOCKS);
        } else {
            this.func_149647_a(null);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            IBlockState topBlock = world.func_180495_p(pos.func_177984_a());
            if (!(this.full || topBlock.func_177230_c() != Blocks.field_150353_l && topBlock.func_177230_c() != Blocks.field_150356_k || topBlock.func_177230_c().func_176201_c(topBlock) != 0)) {
                world.func_175656_a(pos, BlockRegister.EXTRACTION_DEVICE_ON.func_176223_P());
                world.func_175698_g(pos.func_177984_a());
            }
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockRegister.EXTRACTION_DEVICE);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K) {
            IBlockState topBlock = world.func_180495_p(pos.func_177984_a());
            if (!(this.full || topBlock.func_177230_c() != Blocks.field_150353_l && topBlock.func_177230_c() != Blocks.field_150356_k || topBlock.func_177230_c().func_176201_c(topBlock) != 0)) {
                world.func_175656_a(pos, BlockRegister.EXTRACTION_DEVICE_ON.func_176223_P());
                world.func_175698_g(pos.func_177984_a());
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.full) {
            return false;
        }
        if (!world.field_72995_K && player.func_184586_b(hand).func_77973_b() instanceof InfusionBowl) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
            ItemStack heldStack = player.func_184586_b(hand);
            if (world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76222_j() || world.func_189509_E(pos.func_177977_b())) {
                int lvl = plData.stats().getLevel(Enums.Skills.EXTRACTION);
                world.func_175656_a(pos, BlockRegister.EXTRACTION_DEVICE.func_176223_P());
                if (plData.equipment().getCurrentFullArmourSet() != Enums.ArmourSets.EXTRACTION) {
                    world.func_175656_a(pos.func_177977_b(), Blocks.field_150343_Z.func_176223_P());
                }
                if (ExtractionUtil.shouldGetLoot(lvl)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldStack.func_77972_a(1, (EntityLivingBase)player);
                    }
                    List<ItemStack> loot = ExtractionUtil.getLoot(player);
                    for (ItemStack stack : loot) {
                        if (!stack.func_190926_b()) {
                            player.func_145747_a(StringUtil.getLocale("message.feedback.extraction").func_150257_a((ITextComponent)new TextComponentTranslation(stack.func_77977_a() + ".name", new Object[0])));
                        } else {
                            player.func_145747_a((ITextComponent)StringUtil.getLocale("message.feedback.extraction.nothing"));
                        }
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
                    }
                    player.func_71029_a(StatList.func_188057_b((Item)heldStack.func_77973_b()));
                    plData.stats().addXp(Enums.Skills.EXTRACTION, PlayerUtil.getXpRequiredForNextLevel(lvl) / (float)ExtractionUtil.getXpDenominator(lvl), false, false);
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundsRegister.EXTRACTION_SUCCESS, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (player.field_71093_bK == 0) {
                        plData.stats().addTribute(Enums.Deities.PLUTON, 4);
                    }
                } else {
                    player.func_145747_a((ITextComponent)StringUtil.getLocale("message.feedback.extraction.fail"));
                }
            } else {
                player.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.feedback.extraction.noSpace", TextFormatting.RED));
            }
        }
        return true;
    }
}

