/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.utility;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.generation.misc.RunePostBlock;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class RuneShrine
extends Block {
    public RuneShrine() {
        super(Material.field_151576_e);
        this.func_149663_c("RuneShrine");
        this.setRegistryName("aoa3:rune_shrine");
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(CreativeTabsRegister.FUNCTIONAL_BLOCKS);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() != ItemRegister.UNPOWERED_RUNE && heldStack.func_77973_b() != ItemRegister.CHARGED_RUNE) {
            return true;
        }
        BlockPos basePos = pos.func_177981_b(2);
        Block post1 = world.func_180495_p(basePos.func_177964_d(3).func_177965_g(3)).func_177230_c();
        PlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
        if (post1 instanceof RunePostBlock) {
            if (((RunePostBlock)post1).getLevelReq() <= plData.stats().getLevel(Enums.Skills.RUNATION)) {
                RuneItem rune = ((RunePostBlock)post1).getRune();
                if (rune.isChargedRune() && heldStack.func_77973_b() != ItemRegister.CHARGED_RUNE) {
                    return false;
                }
                Block post2 = world.func_180495_p(basePos.func_177964_d(3).func_177985_f(3)).func_177230_c();
                Block post3 = world.func_180495_p(basePos.func_177970_e(3).func_177965_g(3)).func_177230_c();
                Block post4 = world.func_180495_p(basePos.func_177970_e(3).func_177985_f(3)).func_177230_c();
                if (post1 == post2 && post2 == post3 && post3 == post4) {
                    int runeCount = heldStack.func_190916_E();
                    if (plData.equipment().getCurrentFullArmourSet() == Enums.ArmourSets.RUNATION) {
                        runeCount *= 2;
                    }
                    plData.stats().addXp(Enums.Skills.RUNATION, ((RunePostBlock)post1).getXpGain() * (float)heldStack.func_190916_E(), false, false);
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundsRegister.RUNES_CRAFT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!player.field_71075_bZ.field_75098_d) {
                        int handCount = Math.min(64, runeCount);
                        player.func_184611_a(hand, new ItemStack((Item)rune, handCount));
                        if ((runeCount -= handCount) > 0) {
                            ItemUtil.givePlayerItemOrDrop(player, new ItemStack((Item)rune, runeCount));
                        }
                    } else {
                        while (runeCount > 64) {
                            ItemUtil.givePlayerItemOrDrop(player, new ItemStack((Item)rune, 64));
                            runeCount -= 64;
                        }
                        ItemUtil.givePlayerItemOrDrop(player, new ItemStack((Item)rune, runeCount));
                    }
                    player.field_71069_bz.func_75142_b();
                }
            } else if (player instanceof EntityPlayerMP) {
                PlayerUtil.notifyPlayerOfInsufficientLevel((EntityPlayerMP)player, Enums.Skills.RUNATION, ((RunePostBlock)post1).getLevelReq());
            }
        } else {
            int count = heldStack.func_190916_E();
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            plData.sendThrottledChatMessage("message.feedback.runeShrine.practice", new Object[0]);
            plData.stats().addXp(Enums.Skills.RUNATION, 2 * count, false, false);
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundsRegister.RUNES_CRAFT, SoundCategory.BLOCKS, 1.0f, 1.0f);
            player.field_71069_bz.func_75142_b();
        }
        return true;
    }
}

