/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.mainwindow;

import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.event.KeyBinder;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabBestiary;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabGuides;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabHelp;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabPlayer;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.RenderUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.WebUtil;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class AdventMainGui
extends GuiScreen
implements IProgressMeter {
    private static final ResourceLocation titleResource = AdventOfAscension.instance().getCurrentHoliday() == AdventOfAscension.Holiday.APRIL_FOOLS ? new ResourceLocation("aoa3", "textures/gui/maingui/aoa_title_alt.png") : new ResourceLocation("aoa3", "textures/gui/maingui/aoa_title.png");
    public static String currentLanguage = FMLCommonHandler.instance().getCurrentLanguage();
    protected static final ArrayList<AdventGuiTextures> textures = new ArrayList();
    protected static int currentTextureIndex = 0;
    private static ADVENT_WINDOW_TAB selectedTab = ADVENT_WINDOW_TAB.PLAYER;
    @Nullable
    private static GuiScreen tabScreen;
    protected EntityPlayer player;
    protected static final int guiWidth = 976;
    protected static final int guiHeight = 480;
    protected static final float scale = 0.45f;
    protected static final float scaleInverse = 2.2222223f;
    protected static int scaledRootX;
    protected static int scaledRootY;
    protected static int scaledTabRootX;
    protected static int scaledTabRootY;
    private static int updateMessageTicker;

    public AdventMainGui(EntityPlayer player) {
        this.player = player;
        currentLanguage = FMLCommonHandler.instance().getCurrentLanguage();
        if (textures.isEmpty()) {
            AdventMainGui.prepTextures();
        }
    }

    public static boolean isBlockingKeys() {
        if (tabScreen instanceof AdventGuiTabBestiary) {
            GuiTextField bestiarySearchField = ((AdventGuiTabBestiary)AdventMainGui.tabScreen).searchField;
            return bestiarySearchField != null && bestiarySearchField.func_146206_l();
        }
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new AdventMainGuiTabButton(0, 11, 129, StringUtil.getLocaleString("gui.aoamain.tab.player"), ADVENT_WINDOW_TAB.PLAYER));
        this.field_146292_n.add(new AdventMainGuiTabButton(1, 11, 199, StringUtil.getLocaleString("gui.aoamain.tab.bestiary"), ADVENT_WINDOW_TAB.BESTIARY));
        this.field_146292_n.add(new AdventMainGuiTabButton(2, 11, 269, StringUtil.getLocaleString("gui.aoamain.tab.guides"), ADVENT_WINDOW_TAB.GUIDES));
        this.field_146292_n.add(new AdventMainGuiTabButton(3, 11, 339, StringUtil.getLocaleString("gui.aoamain.tab.help"), ADVENT_WINDOW_TAB.HELP));
        this.correctGuiPositions();
        if (tabScreen == null) {
            this.initTabScreen();
        } else {
            tabScreen.func_73866_w_();
        }
        for (int i = 0; i < textures.size(); ++i) {
            if (!textures.get(i).name.equalsIgnoreCase(ConfigurationUtil.MainConfig.mainWindowTheme)) continue;
            currentTextureIndex = i;
            break;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        AdventGuiTextures currentTextures = textures.get(currentTextureIndex);
        this.field_146297_k.func_110434_K().func_110577_a(currentTextures.backgroundTexture);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.45f, (float)0.45f, (float)0.45f);
        AdventMainGui.func_146110_a((int)scaledRootX, (int)scaledRootY, (float)24.0f, (float)16.0f, (int)976, (int)480, (float)1024.0f, (float)512.0f);
        this.field_146297_k.func_110434_K().func_110577_a(titleResource);
        AdventMainGui.func_146110_a((int)(scaledRootX - 24 + 68), (int)(scaledRootY - 16 + 21), (float)0.0f, (float)0.0f, (int)892, (int)112, (float)892.0f, (float)112.0f);
        GlStateManager.func_179152_a((float)2.2222223f, (float)2.2222223f, (float)2.2222223f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.45f, (float)0.45f, (float)0.45f);
        if (currentTextures.overlayTexture != null) {
            GlStateManager.func_179147_l();
            this.field_146297_k.func_110434_K().func_110577_a(currentTextures.overlayTexture);
            AdventMainGui.func_146110_a((int)(scaledRootX - 24), (int)(scaledRootY - 16), (float)0.0f, (float)0.0f, (int)1024, (int)512, (float)1024.0f, (float)512.0f);
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179139_a((double)1.25, (double)1.25, (double)1.25);
        this.field_146297_k.field_71466_p.func_175065_a("v3.3.6", (float)(scaledRootX + 175) / 1.25f, (float)(scaledRootY + 85) / 1.25f, 0xFFDF00, true);
        if (WebUtil.isUpdateAvailable()) {
            if (--updateMessageTicker <= -30) {
                updateMessageTicker = 90;
            }
            if (updateMessageTicker > 0) {
                String msg = StringUtil.getLocaleStringWithArguments("gui.aoamain.update", WebUtil.getLatestVersion());
                this.field_146297_k.field_71466_p.func_175065_a(msg, (float)((int)((float)(scaledRootX + 925 - this.field_146297_k.field_71466_p.func_78256_a(msg)) / 1.25f)), (float)((int)((float)(scaledRootY + 105) / 1.25f)), 0xE50000, true);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
        if (tabScreen != null) {
            tabScreen.func_73863_a(mouseX, mouseY, partialTicks);
        }
        GlStateManager.func_179152_a((float)2.2222223f, (float)2.2222223f, (float)2.2222223f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void func_193026_g() {
        if (tabScreen instanceof IProgressMeter) {
            ((IProgressMeter)tabScreen).func_193026_g();
        }
    }

    private static void prepTextures() {
        textures.add(new AdventGuiTextures("Default", null, null, null));
        textures.add(new AdventGuiTextures("Jungle", new ResourceLocation("aoa3", "textures/gui/maingui/themes/jungle/background.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/jungle/tab_buttons.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/jungle/overlay.png")));
        textures.add(new AdventGuiTextures("Ancient Ruins", new ResourceLocation("aoa3", "textures/gui/maingui/themes/dark/background.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/dark/tab_buttons.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/ancientruins/overlay.png")));
        textures.add(new AdventGuiTextures("Hell", new ResourceLocation("aoa3", "textures/gui/maingui/themes/hell/background.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/hell/tab_buttons.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/hell/overlay.png")));
        textures.add(new AdventGuiTextures("Crystals", new ResourceLocation("aoa3", "textures/gui/maingui/themes/crystals/background.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/crystals/tab_buttons.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/crystals/overlay.png")));
        textures.add(new AdventGuiTextures("Transparent", new ResourceLocation("aoa3", "textures/gui/maingui/themes/transparent/background.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/transparent/tab_buttons.png"), null));
        textures.add(new AdventGuiTextures("Dark", new ResourceLocation("aoa3", "textures/gui/maingui/themes/dark/background.png"), new ResourceLocation("aoa3", "textures/gui/maingui/themes/dark/tab_buttons.png"), null));
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (tabScreen != null) {
            tabScreen.func_146274_d();
        }
    }

    public void func_146282_l() throws IOException {
        if (!AdventMainGui.isBlockingKeys() && Keyboard.getEventKey() == KeyBinder.keyAdventGui.func_151463_i() && Keyboard.getEventKeyState()) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
        super.func_146282_l();
        if (tabScreen != null) {
            tabScreen.func_146282_l();
        }
    }

    private void initTabScreen() {
        switch (selectedTab) {
            case PLAYER: {
                tabScreen = new AdventGuiTabPlayer();
                tabScreen.func_146280_a(this.field_146297_k, (int)((float)(this.field_146294_l + 182) * 0.45f), (int)((float)(this.field_146295_m + 118) * 0.45f));
                break;
            }
            case HELP: {
                tabScreen = new AdventGuiTabHelp();
                tabScreen.func_146280_a(this.field_146297_k, (int)((float)(this.field_146294_l + 182) * 0.45f), (int)((float)(this.field_146295_m + 118) * 0.45f));
                break;
            }
            case BESTIARY: {
                tabScreen = new AdventGuiTabBestiary();
                tabScreen.func_146280_a(this.field_146297_k, (int)((float)(this.field_146294_l + 182) * 0.45f), (int)((float)(this.field_146295_m + 118) * 0.45f));
                break;
            }
            case GUIDES: {
                tabScreen = new AdventGuiTabGuides();
                tabScreen.func_146280_a(this.field_146297_k, (int)((float)(this.field_146294_l + 182) * 0.45f), (int)((float)(this.field_146295_m + 118) * 0.45f));
                break;
            }
            default: {
                tabScreen = null;
            }
        }
    }

    private ResourceLocation getTitleBarTexture() {
        return titleResource;
    }

    public boolean func_73868_f() {
        return ConfigurationUtil.MainConfig.mainWindowPausesGame;
    }

    private void correctGuiPositions() {
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        scaledRootX = (int)(Math.round((double)res.func_78326_a() / 2.0 / (double)0.45f) - Math.round(488.0));
        scaledRootY = (int)(Math.round((double)res.func_78328_b() / 2.0 / (double)0.45f) - Math.round(240.0));
        scaledTabRootX = scaledRootX + 201;
        scaledTabRootY = scaledRootY + 129;
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof AdventMainGuiTabButton) {
            selectedTab = ((AdventMainGuiTabButton)button).tabID;
            this.initTabScreen();
        }
    }

    public void func_175273_b(Minecraft mcIn, int width, int height) {
        super.func_175273_b(mcIn, width, height);
        this.correctGuiPositions();
        if (tabScreen != null) {
            tabScreen.func_175273_b(this.field_146297_k, (int)((float)(width + 182) * 0.45f), (int)((float)(height + 118) * 0.45f));
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (tabScreen != null) {
            tabScreen.func_146281_b();
        }
    }

    public static void addTheme(String name, @Nullable ResourceLocation backgroundTexture, @Nullable ResourceLocation menuButtonsTexture, @Nullable ResourceLocation overlayTexture) {
        textures.add(new AdventGuiTextures(name, backgroundTexture, menuButtonsTexture, overlayTexture));
    }

    protected static void changeTheme() {
        ConfigurationUtil.changeMainWindowTheme(textures.get(currentTextureIndex).name);
    }

    static {
        updateMessageTicker = 0;
    }

    protected static class AdventGuiTextures {
        private final String name;
        @Nullable
        protected final ResourceLocation overlayTexture;
        protected final ResourceLocation backgroundTexture;
        protected final ResourceLocation menuButtonTexture;

        private AdventGuiTextures(String name, @Nullable ResourceLocation backgroundTexture, @Nullable ResourceLocation menuButtonTexture, @Nullable ResourceLocation overlayTexture) {
            this.name = name;
            this.backgroundTexture = backgroundTexture == null ? new ResourceLocation("aoa3", "textures/gui/maingui/themes/default/background.png") : backgroundTexture;
            this.menuButtonTexture = menuButtonTexture == null ? new ResourceLocation("aoa3", "textures/gui/maingui/themes/default/tab_buttons.png") : menuButtonTexture;
            this.overlayTexture = overlayTexture;
        }
    }

    private static class AdventMainGuiTabButton
    extends GuiButton {
        private static final int buttonWidth = 180;
        private static final int buttonHeight = 60;
        private final ADVENT_WINDOW_TAB tabID;

        private AdventMainGuiTabButton(int buttonId, int x, int y, String buttonText, ADVENT_WINDOW_TAB tab) {
            super(buttonId, x, y, 180, 60, buttonText);
            this.tabID = tab;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(AdventMainGui.textures.get((int)AdventMainGui.currentTextureIndex).menuButtonTexture);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179152_a((float)0.45f, (float)0.45f, (float)0.45f);
                this.field_146123_n = this.isMouseInRegion(mouseX, mouseY, this.field_146128_h, this.field_146129_i);
                boolean textureX = false;
                int textureY = 60 * (this.tabID == selectedTab ? 0 : (this.func_146114_a(this.field_146123_n) == 2 ? 1 : 2));
                AdventMainGuiTabButton.func_152125_a((int)(scaledRootX + this.field_146128_h), (int)(scaledRootY + this.field_146129_i), (float)((float)textureX), (float)textureY, (int)180, (int)60, (int)180, (int)60, (float)180.0f, (float)180.0f);
                int stringColour = 15698295;
                if (this.packedFGColour != 0) {
                    stringColour = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    stringColour = 0xA0A0A0;
                } else if (this.field_146123_n || this.tabID == selectedTab) {
                    stringColour = 16248576;
                }
                RenderUtil.drawCenteredScaledString(mc.field_71466_p, this.field_146126_j, scaledRootX + this.field_146128_h + 90, scaledRootY + this.field_146129_i + 25, 2.0f, stringColour, RenderUtil.StringRenderType.OUTLINED);
                GlStateManager.func_179152_a((float)2.2222223f, (float)2.2222223f, (float)2.2222223f);
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            return this.field_146124_l && this.field_146123_n && selectedTab != this.tabID;
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= (int)((float)(scaledRootX + buttonX) * 0.45f) && mouseX <= (int)((float)(scaledRootX + buttonX + 180) * 0.45f) && mouseY >= (int)((float)(scaledRootY + buttonY) * 0.45f) && mouseY <= (int)((float)(scaledRootY + buttonY + 60) * 0.45f);
        }
    }

    protected static enum ADVENT_WINDOW_TAB {
        PLAYER,
        BESTIARY,
        GUIDES,
        LEADERBOARDS,
        HELP;

    }
}

