/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.merchants;

import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.utils.StringUtil;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class TraderGui
extends GuiContainer {
    private final IMerchant trader;
    private final ResourceLocation guiTexture;
    private TraderButton nextRecipeButton;
    private TraderButton previousRecipeButton;
    private int currentRecipeIndex = 0;
    private String guiTitle;
    private int lastTradesSize = -1;

    public TraderGui(ContainerMerchant container, IMerchant trader, String guiName) {
        super((Container)container);
        this.trader = trader;
        this.guiTexture = new ResourceLocation("aoa3", "textures/gui/traders/" + guiName + ".png");
        this.guiTitle = trader.func_145748_c_().func_150261_e();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int centerX = (this.field_146294_l - this.field_146999_f) / 2;
        int centerY = (this.field_146295_m - this.field_147000_g) / 2;
        this.nextRecipeButton = new TraderButton(1, centerX + 147, centerY + 23, true, this.guiTexture);
        this.field_146292_n.add(this.nextRecipeButton);
        this.previousRecipeButton = new TraderButton(2, centerX + 17, centerY + 23, false, this.guiTexture);
        this.field_146292_n.add(this.previousRecipeButton);
    }

    public void func_73876_c() {
        MerchantRecipeList trades;
        super.func_73876_c();
        if (this.field_146297_k.field_71439_g != null && (trades = this.trader.func_70934_b((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) != null) {
            if (this.lastTradesSize < 0) {
                this.lastTradesSize = 0;
            } else if (trades.size() > this.lastTradesSize) {
                this.lastTradesSize = trades.size();
                ((ContainerMerchant)this.field_147002_h).func_75174_d().func_70470_g();
            }
            this.nextRecipeButton.field_146124_l = this.currentRecipeIndex < trades.size() - 1;
            this.previousRecipeButton.field_146124_l = this.currentRecipeIndex > 0;
        }
    }

    protected void func_146284_a(GuiButton button) {
        boolean changeRecipe = false;
        if (button == this.nextRecipeButton) {
            MerchantRecipeList trades = this.trader.func_70934_b((EntityPlayer)this.field_146297_k.field_71439_g);
            this.currentRecipeIndex = trades == null ? 0 : Math.min(trades.size() - 1, this.currentRecipeIndex + 1);
            changeRecipe = true;
        } else if (button == this.previousRecipeButton) {
            this.currentRecipeIndex = Math.max(0, this.currentRecipeIndex - 1);
            changeRecipe = true;
        }
        if (changeRecipe) {
            PacketBuffer packet = new PacketBuffer(Unpooled.buffer());
            ((ContainerMerchant)this.field_147002_h).func_75175_c(this.currentRecipeIndex);
            packet.writeInt(this.currentRecipeIndex);
            try {
                this.field_146297_k.func_147114_u().func_147297_a((Packet)new CPacketCustomPayload("MC|TrSel", packet));
            }
            catch (NullPointerException ex) {
                AdventOfAscension.logMessage(Level.ERROR, "Unable to send trader recipe info", ex);
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        MerchantRecipe trade;
        MerchantRecipeList trades;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.guiTexture);
        int centerX = (this.field_146294_l - this.field_146999_f) / 2;
        int centerY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(centerX, centerY, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.field_146297_k.field_71439_g != null && (trades = this.trader.func_70934_b((EntityPlayer)this.field_146297_k.field_71439_g)) != null && !trades.isEmpty() && (trade = (MerchantRecipe)trades.get(this.currentRecipeIndex)).func_82784_g()) {
            this.field_146297_k.func_110434_K().func_110577_a(this.guiTexture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            this.func_73729_b(this.field_147003_i + 83, this.field_147009_r + 21, 212, 0, 28, 21);
            this.func_73729_b(this.field_147003_i + 83, this.field_147009_r + 51, 212, 0, 28, 21);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawTradeItems(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    private void drawTradeItems(int mouseX, int mouseY, float partialTicks) {
        MerchantRecipeList trades = this.trader.func_70934_b((EntityPlayer)this.field_146297_k.field_71439_g);
        if (trades != null && !trades.isEmpty()) {
            int centreX = (this.field_146294_l - this.field_146999_f) / 2;
            int centreY = (this.field_146295_m - this.field_147000_g) / 2;
            MerchantRecipe trade = (MerchantRecipe)trades.get(this.currentRecipeIndex);
            ItemStack buyStack1 = trade.func_77394_a();
            ItemStack buyStack2 = trade.func_77396_b();
            ItemStack sellStack = trade.func_77397_d();
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GlStateManager.func_179142_g();
            GlStateManager.func_179145_e();
            this.field_146296_j.field_77023_b = 100.0f;
            this.field_146296_j.func_180450_b(buyStack1, centreX + 36, centreY + 24);
            this.field_146296_j.func_175030_a(this.field_146289_q, buyStack1, centreX + 36, centreY + 24);
            if (!buyStack2.func_190926_b()) {
                this.field_146296_j.func_180450_b(buyStack2, centreX + 62, centreY + 24);
                this.field_146296_j.func_175030_a(this.field_146289_q, buyStack2, centreX + 62, centreY + 24);
            }
            this.field_146296_j.func_180450_b(sellStack, centreX + 120, centreY + 24);
            this.field_146296_j.func_175030_a(this.field_146289_q, sellStack, centreX + 120, centreY + 24);
            this.field_146296_j.field_77023_b = 0.0f;
            GlStateManager.func_179140_f();
            if (!buyStack1.func_190926_b() && this.func_146978_c(36, 24, 16, 16, mouseX, mouseY)) {
                this.func_146285_a(buyStack1, mouseX, mouseY);
            } else if (!buyStack2.func_190926_b() && this.func_146978_c(62, 24, 16, 16, mouseX, mouseY)) {
                this.func_146285_a(buyStack2, mouseX, mouseY);
            } else if (!sellStack.func_190926_b() && this.func_146978_c(120, 24, 16, 16, mouseX, mouseY)) {
                this.func_146285_a(sellStack, mouseX, mouseY);
            } else if (trade.func_82784_g() && (this.func_146978_c(83, 21, 28, 21, mouseX, mouseY) || this.func_146978_c(83, 51, 28, 21, mouseX, mouseY))) {
                this.func_146279_a(I18n.func_135052_a((String)"merchant.deprecated", (Object[])new Object[0]), mouseX, mouseY);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int titleWidth = 4 + this.field_146297_k.field_71466_p.func_78256_a(this.guiTitle);
        if (titleWidth > this.field_146999_f - 28 && this.trader instanceof Entity) {
            this.guiTitle = StringUtil.getLocaleString("entity." + EntityList.func_75621_b((Entity)((Entity)this.trader)) + ".name");
            titleWidth = 4 + this.field_146297_k.field_71466_p.func_78256_a(this.guiTitle);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.guiTexture);
        this.func_73729_b(28, 4, 212, 21, 1, 12);
        for (int i = 0; i < titleWidth - 2; ++i) {
            this.func_73729_b(29 + i, 4, 213, 21, 1, 12);
        }
        this.func_73729_b(28 + titleWidth - 2, 4, 214, 21, 1, 12);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71466_p.func_78276_b(this.guiTitle, 30, 6, 0xFFFFFF);
    }

    @SideOnly(value=Side.CLIENT)
    private class TraderButton
    extends GuiButton {
        private final ResourceLocation buttonTexture;
        private final boolean isNextButton;

        private TraderButton(int buttonId, int x, int y, boolean isNextButton, ResourceLocation textureResource) {
            super(buttonId, x, y, 12, 19, "");
            this.isNextButton = isNextButton;
            this.buttonTexture = textureResource;
            this.field_146124_l = false;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(this.buttonTexture);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int textureXIndex = 176;
                if (!this.field_146124_l) {
                    textureXIndex += this.field_146120_f * 2;
                } else if (mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g) {
                    textureXIndex += this.field_146120_f;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, textureXIndex, this.isNextButton ? 0 : this.field_146121_g, this.field_146120_f, this.field_146121_g);
            }
        }
    }
}

