/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.toasts;

import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.RenderUtil;
import net.tslat.aoa3.utils.StringUtil;

@SideOnly(value=Side.CLIENT)
public class ResourceRequirementToast
implements IToast {
    private static final ResourceLocation resourcesTextures = new ResourceLocation("aoa3", "textures/gui/maingui/resources.png");
    private final Enums.Resources resource;
    private int iconUvX = 0;
    private int iconUvY = 0;
    private final float resourceAmount;
    private final String title;
    private final String subtitle;

    public ResourceRequirementToast(Enums.Resources relevantResource, float resourceRequirement) {
        this.resource = relevantResource;
        this.resourceAmount = resourceRequirement;
        this.title = StringUtil.getColourLocaleString("gui.aoatoast.resourceReq.title", TextFormatting.DARK_RED);
        this.subtitle = StringUtil.getLocaleStringWithArguments("gui.aoatoast.resourceReq.subtitle", StringUtil.capitaliseFirstLetter(relevantResource.toString()), StringUtil.roundToNthDecimalPlace(resourceRequirement, 2));
        this.applyIconUvs(relevantResource);
    }

    public Enums.Resources getResource() {
        return this.resource;
    }

    public float getAmountRequired() {
        return this.resourceAmount;
    }

    public IToast.Visibility func_193653_a(GuiToast toastGui, long delta) {
        toastGui.func_192989_b().func_110434_K().func_110577_a(field_193654_a);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        toastGui.func_73729_b(0, 0, 0, 0, 160, 32);
        toastGui.func_192989_b().func_110434_K().func_110577_a(resourcesTextures);
        RenderUtil.drawScaledCustomSizeModalRect(6.0, 6.0, this.iconUvX, this.iconUvY, 50.0f, 50.0f, 20.0, 20.0, 400.0f, 590.0f);
        toastGui.func_192989_b().field_71466_p.func_78276_b(this.title, 30, 7, -11534256);
        toastGui.func_192989_b().field_71466_p.func_78276_b(this.subtitle, 30, 18, 0xFFFFFF);
        return delta >= 3000L ? IToast.Visibility.HIDE : IToast.Visibility.SHOW;
    }

    private void applyIconUvs(Enums.Resources skill) {
        switch (skill) {
            case CREATION: {
                this.iconUvX = 0;
                this.iconUvY = 340;
                break;
            }
            case ENERGY: {
                this.iconUvX = 0;
                this.iconUvY = 140;
                break;
            }
            case RAGE: {
                this.iconUvX = 0;
                this.iconUvY = 50;
                break;
            }
            case SOUL: {
                this.iconUvX = 0;
                this.iconUvY = 440;
            }
        }
    }
}

