/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entities.misc;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderEntity;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.entity.misc.tablet.EntitySoulTablet;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class SoulTabletRenderer
extends RenderEntity {
    private static final Random particleRand = new Random();
    private final ResourceLocation texture;
    private final ModelBase model;
    private final int particleId;

    public SoulTabletRenderer(RenderManager renderManager, ModelBase model, ResourceLocation texture, int particleId) {
        super(renderManager);
        this.texture = texture;
        this.model = model;
        this.particleId = particleId;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        EntitySoulTablet tablet;
        try {
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179141_d();
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)-1.5, (double)0.0);
            GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
            this.renderModel(entity, 0.0f, 0.0f, 0.0f, entity.field_70177_z, entity.field_70125_A, 0.0625f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179101_C();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179098_w();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        }
        catch (Exception ex) {
            AdventOfAscension.logMessage(Level.ERROR, "Failed Soul Tablet Render", ex);
            ex.printStackTrace();
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        if (this.particleId > 0 && !Minecraft.func_71410_x().func_147113_T() && (tablet = (EntitySoulTablet)entity).isActive()) {
            int radius = tablet.getRelevantItem().getEffectRadius();
            Minecraft.func_71410_x().field_71452_i.func_178927_a(this.particleId, entity.field_70165_t + (double)(particleRand.nextFloat() * (float)radius * 2.0f) - (double)radius, entity.field_70163_u + (double)(particleRand.nextFloat() * (float)radius * 2.0f) - (double)radius, entity.field_70161_v + (double)(particleRand.nextFloat() * (float)radius * 2.0f) - (double)radius, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void renderModel(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean flag1;
        boolean flag = !entity.func_82150_aj() || this.field_188301_f;
        boolean bl = flag1 = !flag && !entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (flag || flag1) {
            if (!this.func_180548_c(entity)) {
                return;
            }
            if (flag1) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            this.model.func_78088_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            if (flag1) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    @Nullable
    protected ResourceLocation func_110775_a(Entity entity) {
        return this.texture;
    }
}

