/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entities.mobs.creeponia;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.client.render.entities.AoAMeleeMobRenderer;
import net.tslat.aoa3.client.render.entities.layers.RenderLayerCustomCreeperCharge;
import net.tslat.aoa3.entity.mobs.creeponia.EntityCreeponiaCreeper;
import net.tslat.aoa3.utils.ConfigurationUtil;

@SideOnly(value=Side.CLIENT)
public class CreeponiaCreeperRenderer
extends RenderLiving<EntityCreeponiaCreeper> {
    private final ResourceLocation texture;
    private final ModelBase model;

    public CreeponiaCreeperRenderer(RenderManager renderManager, ModelBase model, float entityWidth, ResourceLocation textureResource) {
        super(renderManager, model, entityWidth / 3.0f);
        this.model = model;
        this.texture = textureResource;
        this.func_177094_a(new RenderLayerCustomCreeperCharge(this));
    }

    public ModelBase func_177087_b() {
        return ConfigurationUtil.MainConfig.funOptions.alwaysChargers ? AoAMeleeMobRenderer.chargerModel : super.func_177087_b();
    }

    protected void preRenderCallback(EntityCreeponiaCreeper creeper, float partialTickTime) {
        float flashIntensity = creeper.func_70831_j(partialTickTime);
        float scaleRotationMod = 1.0f + MathHelper.func_76126_a((float)(flashIntensity * 100.0f)) * flashIntensity * 0.01f;
        flashIntensity = (float)Math.pow(MathHelper.func_76131_a((float)flashIntensity, (float)0.0f, (float)1.0f), 3.0);
        float scaleHorizontal = (1.0f + flashIntensity * 0.4f) * scaleRotationMod;
        float scaleVertical = (1.0f + flashIntensity * 0.1f) / scaleRotationMod;
        GlStateManager.func_179152_a((float)scaleHorizontal, (float)scaleVertical, (float)scaleHorizontal);
    }

    protected int getColorMultiplier(EntityCreeponiaCreeper creeper, float lightBrightness, float partialTickTime) {
        float flashIntensity = creeper.func_70831_j(partialTickTime);
        if ((int)(flashIntensity * 10.0f) % 2 == 0) {
            return 0;
        }
        int flashColourMod = MathHelper.func_76125_a((int)((int)(flashIntensity * 0.2f * 255.0f)), (int)0, (int)255);
        return flashColourMod << 24 | 0x30FFFFFF;
    }

    protected void renderModel(EntityCreeponiaCreeper entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean notInvisible;
        boolean visible = this.func_193115_c((EntityLivingBase)entity);
        boolean bl = notInvisible = !visible && !entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (visible || notInvisible) {
            if (!this.func_180548_c((Entity)entity)) {
                return;
            }
            if (notInvisible) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            (ConfigurationUtil.MainConfig.funOptions.alwaysChargers ? AoAMeleeMobRenderer.chargerModel : this.field_77045_g).func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            if (notInvisible) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityCreeponiaCreeper mob) {
        return ConfigurationUtil.MainConfig.funOptions.alwaysChargers ? AoAMeleeMobRenderer.chargerTexture : this.texture;
    }
}

