/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.EntityNotFoundException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class CommandAoASkill
extends CommandBase {
    private static final TextComponentString commandPrefix = new TextComponentString(TextFormatting.DARK_RED + "[AoA" + TextFormatting.GOLD + "Skill" + TextFormatting.DARK_RED + "] ");

    public String func_71517_b() {
        return "aoaskill";
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("aoaskills");
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.aoaskill.usage";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return super.func_184882_a(server, sender);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.messageSender(sender, Enums.CommandFeedbackType.INFO, "command.aoaskill.desc", new String[0]);
            return;
        }
        block19 : switch (args[0]) {
            case "check": {
                Enums.Skills skill;
                EntityPlayer pl;
                if (args.length < 3) {
                    this.messageSender(sender, Enums.CommandFeedbackType.WARN, "command.aoaskill.check.usage", new String[0]);
                    return;
                }
                try {
                    pl = (EntityPlayer)CommandAoASkill.func_184884_a((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance(), (ICommandSender)sender, (String)args[1], EntityPlayer.class);
                    skill = Enums.Skills.valueOf(args[2].toUpperCase());
                }
                catch (EntityNotFoundException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noPlayer", args[1]);
                    return;
                }
                catch (IllegalArgumentException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noSkill", args[2]);
                    return;
                }
                PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
                int lvl = plData.stats().getLevelForDisplay(skill);
                sender.func_145747_a((ITextComponent)StringUtil.getColourLocaleWithArguments("command.aoaskill.check.player", TextFormatting.GRAY, pl.getDisplayNameString()));
                sender.func_145747_a((ITextComponent)StringUtil.getColourLocaleWithArguments("command.aoaskill.check.data", TextFormatting.GRAY, StringUtil.capitaliseFirstLetter(skill.toString()), String.valueOf(lvl), String.valueOf(plData.stats().getExp(skill)), String.valueOf(PlayerUtil.getXpRequiredForNextLevel(lvl))));
                break;
            }
            case "setlevel": {
                EntityPlayer pl;
                Enums.Skills skill;
                int lvl;
                switch (args.length) {
                    default: {
                        this.messageSender(sender, Enums.CommandFeedbackType.WARN, "command.aoaskill.setlevel.usage", new String[0]);
                        break block19;
                    }
                    case 3: {
                        EntityPlayer pl2;
                        Enums.Skills skill2;
                        int lvl2;
                        try {
                            lvl2 = MathHelper.func_76125_a((int)Integer.parseInt(args[2]), (int)1, (int)1000);
                            skill2 = Enums.Skills.valueOf(args[1].toUpperCase());
                            if (!(sender.func_174793_f() instanceof EntityPlayer)) {
                                this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noConsole", "/aoaskill setlevel <skill> <level>");
                                return;
                            }
                            pl2 = (EntityPlayer)sender.func_174793_f();
                        }
                        catch (NumberFormatException e) {
                            this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.invalidArgument", args[2]);
                            return;
                        }
                        catch (IllegalArgumentException e) {
                            this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noSkill", args[1]);
                            return;
                        }
                        PlayerUtil.getAdventPlayer(pl2).stats().setLevel(skill2, lvl2);
                        this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoaskill.setlevel.success", pl2.getDisplayNameString(), StringUtil.capitaliseFirstLetter(skill2.toString()), String.valueOf(lvl2));
                        break block19;
                    }
                    case 4: 
                }
                try {
                    lvl = MathHelper.func_76125_a((int)Integer.parseInt(args[3]), (int)1, (int)1000);
                    skill = Enums.Skills.valueOf(args[1].toUpperCase());
                    pl = (EntityPlayer)CommandAoASkill.func_184884_a((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance(), (ICommandSender)sender, (String)args[2], EntityPlayer.class);
                }
                catch (EntityNotFoundException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noPlayer", args[2]);
                    return;
                }
                catch (NumberFormatException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.invalidArgument", args[3]);
                    return;
                }
                catch (IllegalArgumentException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noSkill", args[1]);
                    return;
                }
                PlayerUtil.getAdventPlayer(pl).stats().setLevel(skill, lvl);
                this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoaskill.setlevel.success", pl.getDisplayNameString(), StringUtil.capitaliseFirstLetter(skill.toString()), String.valueOf(lvl));
                break;
            }
            case "addlevel": {
                EntityPlayer pl;
                Enums.Skills skill;
                switch (args.length) {
                    default: {
                        this.messageSender(sender, Enums.CommandFeedbackType.WARN, "command.aoaskill.addlevel.usage", new String[0]);
                        break block19;
                    }
                    case 2: {
                        EntityPlayer pl3;
                        Enums.Skills skill3;
                        try {
                            skill3 = Enums.Skills.valueOf(args[1].toUpperCase());
                            if (!(sender.func_174793_f() instanceof EntityPlayer)) {
                                this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noConsole", "/aoaskill addlevel <skill>");
                                return;
                            }
                            pl3 = (EntityPlayer)sender.func_174793_f();
                        }
                        catch (IllegalArgumentException e) {
                            this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noSkill", args[1]);
                            return;
                        }
                        PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl3);
                        int lvl = Math.min(1000, plData.stats().getLevelForDisplay(skill3) + 1);
                        plData.stats().setLevel(skill3, lvl);
                        this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoaskill.addlevel.success", pl3.getDisplayNameString(), StringUtil.capitaliseFirstLetter(skill3.toString()), String.valueOf(lvl));
                        break block19;
                    }
                    case 3: 
                }
                try {
                    skill = Enums.Skills.valueOf(args[1].toUpperCase());
                    pl = (EntityPlayer)CommandAoASkill.func_184884_a((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance(), (ICommandSender)sender, (String)args[2], EntityPlayer.class);
                }
                catch (EntityNotFoundException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noPlayer", args[2]);
                    return;
                }
                catch (IllegalArgumentException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noSkill", args[1]);
                    return;
                }
                PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
                int lvl = Math.min(1000, plData.stats().getLevelForDisplay(skill) + 1);
                plData.stats().setLevel(skill, lvl);
                this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoaskill.addlevel.success", pl.getDisplayNameString(), StringUtil.capitaliseFirstLetter(skill.toString()), String.valueOf(lvl));
                break;
            }
            case "removelevel": {
                EntityPlayer pl;
                Enums.Skills skill;
                switch (args.length) {
                    default: {
                        this.messageSender(sender, Enums.CommandFeedbackType.WARN, "command.aoaskill.removelevel.usage", new String[0]);
                        break block19;
                    }
                    case 2: {
                        EntityPlayer pl4;
                        Enums.Skills skill4;
                        try {
                            skill4 = Enums.Skills.valueOf(args[1].toUpperCase());
                            if (!(sender.func_174793_f() instanceof EntityPlayer)) {
                                this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noConsole", "/aoaskill removelevel <skill>");
                                return;
                            }
                            pl4 = (EntityPlayer)sender.func_174793_f();
                        }
                        catch (IllegalArgumentException e) {
                            this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noSkill", args[1]);
                            return;
                        }
                        PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl4);
                        int lvl = Math.max(1, plData.stats().getLevelForDisplay(skill4) - 1);
                        plData.stats().setLevel(skill4, lvl);
                        this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoaskill.removelevel.success", pl4.getDisplayNameString(), StringUtil.capitaliseFirstLetter(skill4.toString()), String.valueOf(lvl));
                        break block19;
                    }
                    case 3: 
                }
                try {
                    skill = Enums.Skills.valueOf(args[1].toUpperCase());
                    pl = (EntityPlayer)CommandAoASkill.func_184884_a((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance(), (ICommandSender)sender, (String)args[2], EntityPlayer.class);
                }
                catch (EntityNotFoundException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noPlayer", args[2]);
                    return;
                }
                catch (IllegalArgumentException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noSkill", args[1]);
                    return;
                }
                PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
                int lvl = Math.max(1, plData.stats().getLevelForDisplay(skill) - 1);
                plData.stats().setLevel(skill, lvl);
                this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoaskill.removelevel.success", pl.getDisplayNameString(), StringUtil.capitaliseFirstLetter(skill.toString()), String.valueOf(lvl));
                break;
            }
            case "addxp": {
                EntityPlayer pl;
                Enums.Skills skill;
                float xp;
                switch (args.length) {
                    default: {
                        this.messageSender(sender, Enums.CommandFeedbackType.WARN, "command.aoaskill.addxp.usage", new String[0]);
                        break block19;
                    }
                    case 3: {
                        EntityPlayer pl5;
                        Enums.Skills skill5;
                        float xp2;
                        try {
                            xp2 = MathHelper.func_76131_a((float)Float.parseFloat(args[2]), (float)0.0f, (float)2.1474836E9f);
                            skill5 = Enums.Skills.valueOf(args[1].toUpperCase());
                            if (!(sender.func_174793_f() instanceof EntityPlayer)) {
                                this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noConsole", "/aoaskill addxp <skill> <xp>");
                                return;
                            }
                            pl5 = (EntityPlayer)sender.func_174793_f();
                        }
                        catch (NumberFormatException e) {
                            this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.invalidArgument", args[2]);
                            return;
                        }
                        catch (IllegalArgumentException e) {
                            this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noSkill", args[1]);
                            return;
                        }
                        this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoaskill.addxp.success", pl5.getDisplayNameString(), StringUtil.capitaliseFirstLetter(skill5.toString()), String.valueOf(xp2));
                        PlayerUtil.getAdventPlayer(pl5).stats().addXp(skill5, xp2, true, false);
                        break block19;
                    }
                    case 4: 
                }
                try {
                    xp = MathHelper.func_76131_a((float)Float.parseFloat(args[3]), (float)0.0f, (float)2.1474836E9f);
                    skill = Enums.Skills.valueOf(args[1].toUpperCase());
                    pl = (EntityPlayer)CommandAoASkill.func_184884_a((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance(), (ICommandSender)sender, (String)args[2], EntityPlayer.class);
                }
                catch (EntityNotFoundException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noPlayer", args[2]);
                    return;
                }
                catch (NumberFormatException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.invalidArgument", args[3]);
                    return;
                }
                catch (IllegalArgumentException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noSkill", args[1]);
                    return;
                }
                PlayerUtil.getAdventPlayer(pl).stats().addXp(skill, xp, true, false);
                this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoaskill.addxp.success", pl.getDisplayNameString(), StringUtil.capitaliseFirstLetter(skill.toString()), String.valueOf(xp));
                break;
            }
            case "removexp": {
                EntityPlayer pl;
                Enums.Skills skill;
                float xp;
                switch (args.length) {
                    default: {
                        this.messageSender(sender, Enums.CommandFeedbackType.WARN, "command.aoaskill.removexp.usage", new String[0]);
                        break block19;
                    }
                    case 3: {
                        EntityPlayer pl6;
                        Enums.Skills skill6;
                        float xp3;
                        try {
                            xp3 = MathHelper.func_76131_a((float)Float.parseFloat(args[2]), (float)0.0f, (float)2.1474836E9f);
                            skill6 = Enums.Skills.valueOf(args[1].toUpperCase());
                            if (!(sender.func_174793_f() instanceof EntityPlayer)) {
                                this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noConsole", "/aoaskill removexp <skill> <xp>");
                                return;
                            }
                            pl6 = (EntityPlayer)sender.func_174793_f();
                        }
                        catch (NumberFormatException e) {
                            this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.invalidArgument", args[2]);
                            return;
                        }
                        catch (IllegalArgumentException e) {
                            this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noSkill", args[1]);
                            return;
                        }
                        PlayerUtil.getAdventPlayer(pl6).stats().subtractXp(skill6, xp3);
                        this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoaskill.removexp.success", pl6.getDisplayNameString(), StringUtil.capitaliseFirstLetter(skill6.toString()), String.valueOf(xp3));
                        break block19;
                    }
                    case 4: 
                }
                try {
                    xp = MathHelper.func_76131_a((float)Float.parseFloat(args[3]), (float)0.0f, (float)2.1474836E9f);
                    skill = Enums.Skills.valueOf(args[1].toUpperCase());
                    pl = (EntityPlayer)CommandAoASkill.func_184884_a((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance(), (ICommandSender)sender, (String)args[2], EntityPlayer.class);
                }
                catch (EntityNotFoundException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noPlayer", args[2]);
                    return;
                }
                catch (NumberFormatException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.invalidArgument", args[3]);
                    return;
                }
                catch (IllegalArgumentException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoa.noSkill", args[1]);
                    return;
                }
                PlayerUtil.getAdventPlayer(pl).stats().subtractXp(skill, xp);
                this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoaskill.removexp.success", pl.getDisplayNameString(), StringUtil.capitaliseFirstLetter(skill.toString()), String.valueOf(xp));
                break;
            }
            default: {
                this.messageSender(sender, Enums.CommandFeedbackType.WARN, "command.aoaskill.usage", new String[0]);
            }
        }
    }

    public int func_82362_a() {
        return 4;
    }

    private void messageSender(ICommandSender sender, Enums.CommandFeedbackType type, String langKey, String ... args) {
        sender.func_145747_a(commandPrefix.func_150259_f().func_150257_a(StringUtil.getLocaleWithArguments(langKey, args).func_150255_a(new Style().func_150238_a(type.getColour()))));
    }
}

