/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common;

import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.client.event.ClientEventHandler;
import net.tslat.aoa3.client.event.KeyBinder;
import net.tslat.aoa3.client.gui.render.BossBarRenderer;
import net.tslat.aoa3.client.gui.render.EntityPropertiesRenderer;
import net.tslat.aoa3.client.gui.render.HelmetScreenRenderer;
import net.tslat.aoa3.client.gui.render.ResourcesRenderer;
import net.tslat.aoa3.client.gui.render.ScreenOverlayRenderer;
import net.tslat.aoa3.client.gui.render.SkillsRenderer;
import net.tslat.aoa3.client.gui.render.SniperGuiRenderer;
import net.tslat.aoa3.client.gui.render.XpParticlesRenderer;
import net.tslat.aoa3.client.gui.toasts.LevelRequirementToast;
import net.tslat.aoa3.client.gui.toasts.ResourceRequirementToast;
import net.tslat.aoa3.client.gui.toasts.TributeRequirementToast;
import net.tslat.aoa3.client.model.entities.player.LayerPlayerHalo;
import net.tslat.aoa3.client.render.entities.projectiles.ProjectileRenders;
import net.tslat.aoa3.client.sound.MusicSound;
import net.tslat.aoa3.common.ServerProxy;
import net.tslat.aoa3.common.packet.PacketToastPopup;
import net.tslat.aoa3.common.packet.leaderboard.PacketLeaderboardStats;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.ParticleRegister;
import net.tslat.aoa3.entity.mobs.greckon.EntitySilencer;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.StringUtil;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends ServerProxy {
    @Override
    public void preInit() {
        KeyBinder.init();
        this.registerClientEvents();
    }

    @Override
    public void postInit() {
        ParticleRegister.doInitTasks();
        ProjectileRenders.postInit();
        for (RenderPlayer playerRenderer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            playerRenderer.func_177094_a((LayerRenderer)new LayerPlayerHalo(playerRenderer));
        }
    }

    @Override
    public void handleLeaderboardData(PacketLeaderboardStats packet) {
    }

    @Override
    public void worldShutdown() {
        BossBarRenderer.boss = null;
    }

    @Override
    public void displayScreenOverlay(int ticks, Enums.ScreenOverlays screen) {
        ScreenOverlayRenderer.overlayTicks = ticks;
        ScreenOverlayRenderer.screen = screen;
    }

    @Override
    public void addRecoil(float recoil, int firingTime) {
        ClientEventHandler.recoilTicks = Math.min(50, firingTime);
        ClientEventHandler.recoilTicksRemaining = Math.min(50, firingTime);
        ClientEventHandler.recoilAngle = recoil;
    }

    @Override
    public void setPlayerHealth(float health) {
        Minecraft.func_71410_x().field_71439_g.func_70606_j(health);
    }

    private void registerClientEvents() {
        EventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.register((Object)new KeyBinder());
        forgeBus.register((Object)new EntityPropertiesRenderer());
        forgeBus.register((Object)new SniperGuiRenderer());
        forgeBus.register((Object)new HelmetScreenRenderer());
        forgeBus.register((Object)new ScreenOverlayRenderer());
        forgeBus.register((Object)new ResourcesRenderer());
        forgeBus.register((Object)new SkillsRenderer());
        forgeBus.register((Object)new XpParticlesRenderer());
        forgeBus.register((Object)new BossBarRenderer());
        forgeBus.register((Object)new ClientEventHandler());
        forgeBus.register((Object)new ProjectileRenders());
        forgeBus.register((Object)new ParticleRegister());
    }

    @Override
    public void displayToast(PacketToastPopup.ToastPopupType type, Object subject, Object value) {
        switch (type) {
            case SKILL_REQUIREMENT: {
                if (ConfigurationUtil.MainConfig.useToasts) {
                    Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new LevelRequirementToast((Enums.Skills)((Object)subject), (Integer)value));
                    break;
                }
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)StringUtil.getColourLocaleWithArguments("message.feedback.insufficientLevels", TextFormatting.RED, String.valueOf(value), StringUtil.capitaliseFirstLetter(subject.toString())));
                break;
            }
            case RESOURCE_REQUIREMENT: {
                if (ConfigurationUtil.MainConfig.useToasts) {
                    Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new ResourceRequirementToast((Enums.Resources)((Object)subject), ((Float)value).floatValue()));
                    break;
                }
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)StringUtil.getColourLocaleWithArguments("message.feedback.insufficientResource", TextFormatting.RED, StringUtil.roundToNthDecimalPlace(((Float)value).floatValue(), 2), StringUtil.capitaliseFirstLetter(subject.toString())));
                break;
            }
            case TRIBUTE_REQUIREMENT: {
                if (ConfigurationUtil.MainConfig.useToasts) {
                    Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new TributeRequirementToast((Enums.Deities)((Object)subject), (Integer)value));
                    break;
                }
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)StringUtil.getColourLocaleWithArguments("message.feedback.insufficientTribute", TextFormatting.RED, String.valueOf(value), StringUtil.capitaliseFirstLetter(subject.toString())));
            }
        }
    }

    @Override
    public void setFancyLeaves(BlockLeaves block) {
        block.func_150122_b(Minecraft.func_71410_x().field_71474_y.field_74347_j);
    }

    @Override
    public void registerStateMappers() {
        BlockRegister.registerStateMappers();
    }

    @Override
    public void doSilencerSilence(EntitySilencer silencer) {
        if (silencer.func_70068_e((Entity)Minecraft.func_71410_x().field_71439_g) < 64.0) {
            Minecraft.func_71410_x().func_147118_V().func_147690_c();
        }
    }

    @Override
    public void playMusic(SoundEvent soundEvent, @Nullable Entity linkedEntity) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
            if (!MusicSound.isPlaying(soundEvent, linkedEntity)) {
                this.stopMusic();
                soundHandler.func_147682_a((ISound)new MusicSound(soundEvent, linkedEntity));
            }
        }
    }

    @Override
    public void stopMusic() {
        Minecraft.func_71410_x().func_147118_V().func_147690_c();
    }
}

