/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.containers;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.containers.ContainerBasicUtility;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.ItemRegister;

public class ContainerMendingTable
extends ContainerBasicUtility {
    private int totalMaterialCost = 0;

    public ContainerMendingTable(EntityPlayer player, World world, BlockPos pos) {
        super(player, world, pos);
    }

    @Override
    protected Slot initFirstInputSlot() {
        return new Slot((IInventory)this.inputs, 0, 27, 23){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77984_f();
            }
        };
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K) {
            this.func_193327_a(player, player.field_70170_p, (IInventory)this.inputs);
        }
    }

    @Override
    protected Slot initOutputSlot() {
        return new Slot((IInventory)this.output, 2, 134, 23){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(EntityPlayer playerIn) {
                return this.func_75216_d();
            }

            public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
                if (ContainerMendingTable.this.totalMaterialCost > 0) {
                    ItemStack repairMaterialStack = ContainerMendingTable.this.inputs.func_70301_a(1);
                    if (!repairMaterialStack.func_190926_b() && repairMaterialStack.func_190916_E() >= ContainerMendingTable.this.totalMaterialCost) {
                        repairMaterialStack.func_190918_g(ContainerMendingTable.this.totalMaterialCost);
                    } else {
                        ContainerMendingTable.this.inputs.func_70299_a(1, ItemStack.field_190927_a);
                    }
                } else {
                    ContainerMendingTable.this.inputs.func_70299_a(1, ItemStack.field_190927_a);
                }
                ContainerMendingTable.this.inputs.func_70299_a(0, ItemStack.field_190927_a);
                return stack;
            }
        };
    }

    @Override
    public void updateOutput() {
        ItemStack repairStack = this.inputs.func_70301_a(0);
        if (repairStack.func_190926_b() || !repairStack.func_77984_f()) {
            this.resetMendingContainerState();
        } else {
            ItemStack repairMaterial = this.inputs.func_70301_a(1);
            if (repairMaterial.func_190926_b()) {
                this.resetMendingContainerState();
            } else {
                ItemStack repairedStack = repairStack.func_77946_l();
                if (repairMaterial.func_77973_b() == ItemRegister.MAGIC_REPAIR_DUST || repairMaterial.func_77973_b() == ItemRegister.MAGIC_MENDING_COMPOUND) {
                    int repairPortionValue;
                    int n = repairPortionValue = repairMaterial.func_77973_b() == ItemRegister.MAGIC_MENDING_COMPOUND ? repairedStack.func_77952_i() : Math.min(repairedStack.func_77952_i(), repairedStack.func_77958_k() / 5);
                    if (repairPortionValue <= 0) {
                        this.resetMendingContainerState();
                    } else {
                        int repairCount;
                        for (repairCount = 0; repairPortionValue > 0 && repairCount < repairMaterial.func_190916_E(); ++repairCount) {
                            repairedStack.func_77964_b(repairedStack.func_77952_i() - repairPortionValue);
                            repairPortionValue = Math.min(repairedStack.func_77952_i(), repairedStack.func_77958_k() / 5);
                        }
                        this.totalMaterialCost = repairCount;
                        this.output.func_70299_a(0, repairedStack);
                    }
                }
            }
        }
    }

    private void resetMendingContainerState() {
        this.output.func_70299_a(0, ItemStack.field_190927_a);
        this.totalMaterialCost = 0;
    }

    @Override
    protected String getGuiTitle() {
        return "Mending";
    }

    @Override
    protected Block getBlock() {
        return BlockRegister.MENDING_TABLE;
    }
}

