/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.handlers.PlayerHaloHandler;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import org.apache.logging.log4j.Level;

public class PacketChangedHalo
implements IMessage {
    private String haloChoice;

    public PacketChangedHalo() {
    }

    public PacketChangedHalo(@Nonnull Enums.PlayerHaloTypes.ChoosableHaloTypes haloChoice) {
        this.haloChoice = haloChoice.toString();
    }

    public void fromBytes(ByteBuf buffer) {
        this.haloChoice = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.haloChoice);
    }

    public static class Handler
    implements IMessageHandler<PacketChangedHalo, IMessage> {
        public IMessage onMessage(PacketChangedHalo msg, MessageContext ctx) {
            Enums.PlayerHaloTypes preferredHalo;
            block2: {
                preferredHalo = Enums.PlayerHaloTypes.Donator;
                try {
                    preferredHalo = Enums.PlayerHaloTypes.ChoosableHaloTypes.valueOf(msg.haloChoice).toBaseType();
                }
                catch (IllegalArgumentException e) {
                    if (!ConfigurationUtil.MainConfig.doVerboseDebugging) break block2;
                    AdventOfAscension.logMessage(Level.WARN, "Error parsing halo info from client: " + msg.haloChoice);
                    e.printStackTrace();
                }
            }
            PlayerHaloHandler.syncNewHaloChoice(ctx.getServerHandler().field_147369_b.func_146103_bH().getId(), preferredHalo);
            return null;
        }
    }
}

