/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.handlers.PlayerHaloHandler;
import net.tslat.aoa3.library.Enums;

public class PacketPlayerHaloInfo
implements IMessage {
    private int mapSize;
    private HashMap<UUID, PlayerHaloHandler.PlayerHaloContainer> halosMap;

    public PacketPlayerHaloInfo() {
    }

    public PacketPlayerHaloInfo(UUID uuid, Enums.PlayerHaloTypes halo) {
        this.halosMap = new HashMap();
        this.mapSize = 1;
        this.halosMap.put(uuid, new PlayerHaloHandler.PlayerHaloContainer(halo));
    }

    public PacketPlayerHaloInfo(HashMap<UUID, PlayerHaloHandler.PlayerHaloContainer> halosMap) {
        this.mapSize = halosMap.size();
        this.halosMap = halosMap;
    }

    public void fromBytes(ByteBuf buffer) {
        this.mapSize = buffer.readInt();
        this.halosMap = new HashMap();
        for (int i = 0; i < this.mapSize; ++i) {
            try {
                this.halosMap.put(UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buffer)), new PlayerHaloHandler.PlayerHaloContainer(Enums.PlayerHaloTypes.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buffer))));
                continue;
            }
            catch (Exception e) {
                ++i;
            }
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.mapSize);
        for (Map.Entry<UUID, PlayerHaloHandler.PlayerHaloContainer> entry : this.halosMap.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)entry.getKey().toString());
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)entry.getValue().getPreferredHalo().toString());
        }
    }

    public static class Handler
    implements IMessageHandler<PacketPlayerHaloInfo, IMessage> {
        public IMessage onMessage(PacketPlayerHaloInfo msg, MessageContext ctx) {
            AdventOfAscension.logOptionalMessage("Received player halos map update");
            for (Map.Entry entry : msg.halosMap.entrySet()) {
                PlayerHaloHandler.setHaloChoice((UUID)entry.getKey(), ((PlayerHaloHandler.PlayerHaloContainer)entry.getValue()).getPreferredHalo());
                AdventOfAscension.logOptionalMessage("UUID: " + entry.getKey() + "; Halo: " + ((PlayerHaloHandler.PlayerHaloContainer)entry.getValue()).getPreferredHalo().toString());
            }
            return null;
        }
    }
}

