/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.leaderboard;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.SortedMap;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import org.apache.logging.log4j.Level;

public class PacketIndividualLeaderboardStats
implements IMessage {
    private String name;
    private int byteArraySize;
    private SortedMap<Enums.Skills, Integer> skillRankMap;

    public PacketIndividualLeaderboardStats() {
    }

    public PacketIndividualLeaderboardStats(String playerName, SortedMap<Enums.Skills, Integer> skillRankMap) {
        this.name = playerName;
        this.skillRankMap = skillRankMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromBytes(ByteBuf buffer) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.byteArraySize = buffer.readInt();
        byte[] byteArray = new byte[this.byteArraySize];
        buffer.readBytes(new byte[buffer.readableBytes()]);
        ByteArrayInputStream arrayStreamIn = new ByteArrayInputStream(byteArray);
        ObjectInputStream objectIn = null;
        SortedMap readEntries = null;
        try {
            objectIn = new ObjectInputStream(arrayStreamIn);
            readEntries = (SortedMap)objectIn.readObject();
        }
        catch (Exception e) {
            if (ConfigurationUtil.MainConfig.doVerboseDebugging) {
                AdventOfAscension.logMessage(Level.WARN, "Unable to deserialize packet for leaderboard stats, skipping");
            }
        }
        finally {
            this.skillRankMap = readEntries;
            try {
                arrayStreamIn.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void toBytes(ByteBuf buffer) {
        block14: {
            ByteArrayOutputStream byteStreamOut;
            byte[] entriesByteArray;
            block12: {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
                entriesByteArray = null;
                byteStreamOut = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = null;
                objectOut = new ObjectOutputStream(byteStreamOut);
                objectOut.writeObject(this.skillRankMap);
                objectOut.flush();
                entriesByteArray = byteStreamOut.toByteArray();
                if (entriesByteArray == null) break block12;
                buffer.writeInt(entriesByteArray.length);
                buffer.writeBytes(entriesByteArray);
            }
            try {
                byteStreamOut.close();
            }
            catch (Exception exception) {}
            break block14;
            catch (Exception e) {
                block13: {
                    try {
                        if (ConfigurationUtil.MainConfig.doVerboseDebugging) {
                            AdventOfAscension.logMessage(Level.WARN, "Failed to serialize packet for leaderboard stats, skipping");
                        }
                        if (entriesByteArray == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (entriesByteArray != null) {
                            buffer.writeInt(entriesByteArray.length);
                            buffer.writeBytes(entriesByteArray);
                        }
                        try {
                            byteStreamOut.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    buffer.writeInt(entriesByteArray.length);
                    buffer.writeBytes(entriesByteArray);
                }
                try {
                    byteStreamOut.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        }
    }
}

