/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.celeve;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.event.ForgeEventFactory;
import net.tslat.aoa3.common.registration.BiomeRegister;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.FloatingDimChunk;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class ChunkGenCeleve
implements IChunkGenerator {
    private final World world;
    private final Random rand;
    private ChunkPrimer primer;
    private int curChunkX;
    private int curChunkZ;
    private final Biome biome = BiomeRegister.CELEVE;
    private double[] noiseArray;
    private double[] surfaceBuffer = new double[256];
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorPerlin noiseGen4;
    private NoiseGeneratorOctaves noiseGen5;
    private NoiseGeneratorOctaves noiseGen6;
    private NoiseGeneratorSimplex islandNoise;
    double[] noise1;
    double[] noise2;
    double[] noise3;
    double[] noise5;
    double[] noise6;

    protected ChunkGenCeleve(World world) {
        this.world = world;
        this.rand = new Random(world.func_72905_C());
        this.world.func_181544_b(0);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorPerlin(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.islandNoise = new NoiseGeneratorSimplex(this.rand);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        FloatingDimChunk chunk;
        this.curChunkX = chunkX;
        this.curChunkZ = chunkZ;
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.primer = new ChunkPrimer();
        boolean populatedChunk = this.setBlocksInChunk();
        if (populatedChunk) {
            this.replaceBiomeBlocks();
            chunk = new FloatingDimChunk(this.world, this.primer, this.curChunkX, this.curChunkZ);
        } else {
            chunk = new FloatingDimChunk(this.world, this.curChunkX, this.curChunkZ);
        }
        Arrays.fill(chunk.func_76605_m(), (byte)Biome.func_185362_a((Biome)this.biome));
        chunk.func_76603_b();
        return chunk;
    }

    private double[] generateNoiseField(double[] blockNoiseArray, int chunkXRef, int chunkYRef, int chunkZRef, int p_185963_5_, int p_185963_6_, int p_185963_7_) {
        if (blockNoiseArray == null) {
            blockNoiseArray = new double[p_185963_5_ * p_185963_6_ * p_185963_7_];
        }
        double d0 = 684.412;
        double d1 = 684.412;
        this.noise1 = this.noiseGen3.func_76304_a(this.noise1, chunkXRef, chunkYRef, chunkZRef, p_185963_5_, p_185963_6_, p_185963_7_, (d0 *= 2.0) / 80.0, 4.277575000000001, d0 / 80.0);
        this.noise2 = this.noiseGen1.func_76304_a(this.noise2, chunkXRef, chunkYRef, chunkZRef, p_185963_5_, p_185963_6_, p_185963_7_, d0, 684.412, d0);
        this.noise3 = this.noiseGen2.func_76304_a(this.noise3, chunkXRef, chunkYRef, chunkZRef, p_185963_5_, p_185963_6_, p_185963_7_, d0, 684.412, d0);
        int chunkX = chunkXRef / 2;
        int chunkZ = chunkZRef / 2;
        int k = 0;
        for (int posX = 0; posX < p_185963_5_; ++posX) {
            for (int posZ = 0; posZ < p_185963_7_; ++posZ) {
                for (int j1 = 0; j1 < p_185963_6_; ++j1) {
                    double d2 = this.noise2[k] / 512.0;
                    double d3 = this.noise3[k] / 512.0;
                    double d5 = (this.noise1[k] / 10.0 + 1.0) / 2.0;
                    double d4 = d5 < 0.0 ? d2 : (d5 > 1.0 ? d3 : d2 + (d3 - d2) * d5);
                    d4 -= 8.0;
                    int k1 = 32;
                    if (j1 > p_185963_6_ - k1) {
                        double d6 = (float)(j1 - (p_185963_6_ - k1)) / 31.0f;
                        d4 = d4 * (1.0 - d6) + -15.0 * d6;
                    }
                    if (j1 < (k1 = 8)) {
                        double d7 = (float)(k1 - j1) / ((float)k1 - 1.0f);
                        d4 = d4 * (1.0 - d7) + -30.0 * d7;
                    }
                    blockNoiseArray[k] = d4;
                    ++k;
                }
            }
        }
        return blockNoiseArray;
    }

    private boolean setBlocksInChunk() {
        this.noiseArray = this.generateNoiseField(this.noiseArray, this.curChunkX * 2, 0, this.curChunkZ * 2, 3, 33, 3);
        boolean emptyChunk = true;
        for (int i1 = 0; i1 < 2; ++i1) {
            for (int j1 = 0; j1 < 2; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double d1 = this.noiseArray[(i1 * 3 + j1) * 33 + k1];
                    double d2 = this.noiseArray[(i1 * 3 + j1 + 1) * 33 + k1];
                    double d3 = this.noiseArray[((i1 + 1) * 3 + j1) * 33 + k1];
                    double d4 = this.noiseArray[((i1 + 1) * 3 + j1 + 1) * 33 + k1];
                    double d5 = (this.noiseArray[(i1 * 3 + j1) * 33 + k1 + 1] - d1) * 0.25;
                    double d6 = (this.noiseArray[(i1 * 3 + j1 + 1) * 33 + k1 + 1] - d2) * 0.25;
                    double d7 = (this.noiseArray[((i1 + 1) * 3 + j1) * 33 + k1 + 1] - d3) * 0.25;
                    double d8 = (this.noiseArray[((i1 + 1) * 3 + j1 + 1) * 33 + k1 + 1] - d4) * 0.25;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.0025;
                        double d13 = (d4 - d2) * 0.0025;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d14 = 0.125;
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.125;
                            for (int j2 = 0; j2 < 8; ++j2) {
                                IBlockState blockState = Blocks.field_150350_a.func_176223_P();
                                if (d15 > 0.0) {
                                    blockState = BlockRegister.CELEVE_DIRT.func_176223_P();
                                    emptyChunk = false;
                                }
                                int k2 = i2 + i1 * 8;
                                int l2 = l1 + k1 * 4;
                                int i3 = j2 + j1 * 8;
                                this.primer.func_177855_a(k2, l2, i3, blockState);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
        return !emptyChunk;
    }

    private void replaceBiomeBlocks() {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)this.curChunkX, (int)this.curChunkZ, (ChunkPrimer)this.primer, (World)this.world)) {
            return;
        }
        this.surfaceBuffer = this.noiseGen4.func_151599_a(this.surfaceBuffer, (double)(this.curChunkX * 16), (double)(this.curChunkZ * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                this.generateBiomeTerrain(this.world, this.rand, this.primer, this.curChunkX * 16 + x, this.curChunkZ * 16 + z, this.surfaceBuffer[z + x * 16]);
            }
        }
    }

    private void generateBiomeTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        IBlockState topBlock = this.biome.field_76752_A;
        IBlockState fillerBlock = this.biome.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        for (int j1 = 255; j1 >= 0; --j1) {
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != BlockRegister.CELEVE_DIRT) continue;
            if (j == -1) {
                j = k;
                this.primer.func_177855_a(i1, j1, l, topBlock);
                continue;
            }
            if (j <= 0) continue;
            --j;
            chunkPrimerIn.func_177855_a(i1, j1, l, fillerBlock);
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int y;
        int z;
        int x;
        this.rand.setSeed(this.world.func_72905_C());
        long a = this.rand.nextLong() / 2L * 2L + 1L;
        long b = this.rand.nextLong() / 2L * 2L + 1L;
        int baseX = chunkX * 16 + 1;
        int baseZ = chunkZ * 16 + 1;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos basePos = new BlockPos(baseX, 0, baseZ);
        Biome biome = this.world.func_180494_b(basePos);
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        if (ConfigurationUtil.StructureConfig.celeve.gyroPlatformSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.celeve.gyroPlatformSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(11);
            z = baseZ + this.rand.nextInt(16);
            y = 40 + this.rand.nextInt(20);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x, y, z)).func_177230_c() == Blocks.field_150350_a && this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 17, y + 7, z + 17)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("GyroPlatform", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.celeve.celevianLottoBalloonSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.celeve.celevianLottoBalloonSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(16);
            z = baseZ + this.rand.nextInt(16);
            y = 10 + this.rand.nextInt(20);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 2, y, z + 2)).func_177230_c() == Blocks.field_150350_a && this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, y + 17, z + 8)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("CelevianLottoBalloon", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.celeve.toyTowerSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.celeve.toyTowerSpawnChance) == 0 && this.world.func_180495_p((BlockPos)pos.func_181079_c((x = baseX + this.rand.nextInt(16)) + 5, (y = this.world.func_189649_b(x + 5, (z = baseZ + this.rand.nextInt(16)) + 5)) - 1, z + 5)) == biome.field_76752_A) {
            StructuresHandler.generateStructure("ToyTower", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
        }
        if (ConfigurationUtil.StructureConfig.celeve.compassRuneShrineSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.celeve.compassRuneShrineSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(16);
            z = baseZ + this.rand.nextInt(16);
            y = this.world.func_189649_b(x + 3, z + 3) + 15;
            StructuresHandler.generateStructure("CompassRuneShrine", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
        }
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        biome.func_180624_a(this.world, this.rand, basePos);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

