/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.greckon.biomes;

import com.google.common.base.Predicate;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.worldgen.trees.WorldGenHauntedTree;

public class BiomeGreckon
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Greckon");

    public BiomeGreckon() {
        super(properties);
        this.setRegistryName("aoa3", "greckon");
        this.field_76752_A = BlockRegister.getUnmappedBlock("greckon_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("greckon_dirt").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeGreckonDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.MAGICAL});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.PINK.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.5f);
        properties.func_185395_b(500.0f);
        properties.func_185402_a(new Color(153, 50, 204).getRGB());
        properties.func_185396_a();
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.1f);
    }

    public class BiomeGreckonDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doOreGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            int i;
            for (i = 0; i < ConfigurationUtil.OreConfig.ghastly.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.GHASTLY_ORE.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.ghastly.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.ghastly.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.GRECKON_STONE)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(25) + 3, rand.nextInt(16)));
            }
            for (i = 0; i < ConfigurationUtil.OreConfig.ghoulish.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.GHOULISH_ORE.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.ghoulish.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.ghoulish.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.GRECKON_STONE)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(30) + 30, rand.nextInt(16)));
            }
        }

        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < 15; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16))) - 1, posZ)) != biome.field_76752_A) continue;
                world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.HAUNTED_FLOWER.func_176223_P());
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            posX = basePos.func_177958_n() + rand.nextInt(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 7, (posY = world.func_189649_b(posX + 7, (posZ = basePos.func_177952_p() + rand.nextInt(16)) + 7)) - 1, posZ + 7)) == biome.field_76752_A) {
                new WorldGenHauntedTree(null).func_180709_b(world, rand, pos.func_177984_a());
            }
        }
    }
}

