/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.lunalus;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.tslat.aoa3.common.registration.BiomeRegister;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class ChunkGenLunalus
implements IChunkGenerator {
    private final World world;
    private final Random rand;
    private ChunkPrimer primer;
    private final Biome biome = BiomeRegister.LUNALUS;
    private int x;
    private int y;
    private int z;

    protected ChunkGenLunalus(World world) {
        this.world = world;
        this.rand = new Random(world.func_72905_C());
        this.world.func_181544_b(0);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.primer = new ChunkPrimer();
        this.generateIslands();
        Chunk chunk = new Chunk(this.world, this.primer, chunkX, chunkZ);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biome);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void generateIslands() {
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int y;
        int z;
        int x;
        this.rand.setSeed(this.world.func_72905_C());
        long a = this.rand.nextLong() / 2L * 2L + 1L;
        long b = this.rand.nextLong() / 2L * 2L + 1L;
        int baseX = chunkX * 16 + 1;
        int baseZ = chunkZ * 16 + 1;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos basePos = new BlockPos(baseX, 0, baseZ);
        Biome biome = this.world.func_180494_b(basePos);
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        if (this.rand.nextBoolean()) {
            x = baseX + this.rand.nextInt(4);
            z = baseZ + this.rand.nextInt(4);
            y = 36 + this.rand.nextInt(9);
            if (this.rand.nextBoolean()) {
                StructuresHandler.generateStructure("LunarIsland1", this.world, this.rand, new BlockPos(x, y, z));
            } else {
                StructuresHandler.generateStructure("LunarIsland2", this.world, this.rand, new BlockPos(x, y, z));
            }
        }
        if (this.rand.nextBoolean()) {
            x = baseX + this.rand.nextInt(4);
            z = baseZ + this.rand.nextInt(4);
            y = 61 + this.rand.nextInt(9);
            if (this.rand.nextBoolean()) {
                StructuresHandler.generateStructure("LunarIsland1", this.world, this.rand, new BlockPos(x, y, z));
            } else {
                StructuresHandler.generateStructure("LunarIsland2", this.world, this.rand, new BlockPos(x, y, z));
            }
        }
        if (ConfigurationUtil.StructureConfig.lunalus.lunarVillageSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.lunalus.lunarVillageSpawnChance) == 0) {
            x = baseX;
            z = baseZ;
            y = this.rand.nextInt(4) + 4;
            StructuresHandler.generateStructure("LunarAtom", this.world, this.rand, (BlockPos)pos.func_181079_c(x + 60, y, z + 14));
            StructuresHandler.generateStructure("LunarLottoPlatform", this.world, this.rand, (BlockPos)pos.func_181079_c(x + 85, y, z + 29));
            StructuresHandler.generateStructure("LunarFoodMarket", this.world, this.rand, (BlockPos)pos.func_181079_c(x + 35, y, z));
            StructuresHandler.generateStructure("LunarHerbalHouse", this.world, this.rand, (BlockPos)pos.func_181079_c(x + 15, y, z + 5));
            StructuresHandler.generateStructure("SpellbinderHouse", this.world, this.rand, (BlockPos)pos.func_181079_c(x + 47, y + 22, z + 22));
            StructuresHandler.generateStructure("LunaradeStand", this.world, this.rand, (BlockPos)pos.func_181079_c(x + 28, y + 22, z + 22));
            StructuresHandler.generateStructure("LunarBank", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y + 5, z + 12));
            StructuresHandler.generateStructure("LunarFountain", this.world, this.rand, (BlockPos)pos.func_181079_c(x + 30, y, z + 14));
        } else if (ConfigurationUtil.StructureConfig.lunalus.spaceArenaSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.lunalus.spaceArenaSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(9);
            z = baseZ + this.rand.nextInt(8);
            y = this.rand.nextInt(3) + 15;
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 10, y + 4, z + 11)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("SpaceArena", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.lunalus.lunarCreationPlatformSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.lunalus.lunarCreationPlatformSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(16);
            z = baseZ + this.rand.nextInt(16);
            y = this.rand.nextInt(3) + 15;
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 4, y + 2, z + 4)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("LunarCreationPlatform", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.lunalus.zargPlanetoidSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.lunalus.zargPlanetoidSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(7);
            z = baseZ + this.rand.nextInt(5);
            y = this.rand.nextInt(3) + 15;
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 11, y + 12, z + 12)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("ZargPlanetoid", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.lunalus.lunarMazeSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.lunalus.lunarMazeSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(12);
            z = baseZ + this.rand.nextInt(12);
            y = this.rand.nextInt(3) + 15;
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 9, y + 7, z + 9)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("LunarMaze", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.lunalus.lunarPrisonSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.lunalus.lunarPrisonSpawnChance) == 0) {
            x = baseX;
            z = baseZ + this.rand.nextInt(9);
            y = this.rand.nextInt(3) + 15;
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 18, y + 5, z + 10)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("LunarPrison", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.lunalus.lunarGardenSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.lunalus.lunarGardenSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(13);
            z = baseZ + this.rand.nextInt(13);
            y = this.rand.nextInt(3) + 15;
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, y + 7, z + 8)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("LunarGarden", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.lunalus.observersEyeSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.lunalus.lunarGardenSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(16);
            z = baseZ + this.rand.nextInt(16);
            y = 90 + this.rand.nextInt(10);
            StructuresHandler.generateStructure("ObserversEye", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
        }
        if (ConfigurationUtil.StructureConfig.lunalus.lunarRuneShrineSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.lunalus.lunarRuneShrineSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(16);
            z = baseZ + this.rand.nextInt(16);
            int n = y = this.rand.nextBoolean() ? this.rand.nextInt(20) + 70 : this.rand.nextInt(15) + 6;
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 3, y, z + 3)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("LunarRuneShrine", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        }
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        biome.func_180624_a(this.world, this.rand, basePos);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

