/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.mysterium;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.tslat.aoa3.common.registration.BiomeRegister;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class ChunkGenMysterium
implements IChunkGenerator {
    private final World world;
    private final Random rand;
    private ChunkPrimer primer;
    private final Biome biome = BiomeRegister.MYSTERIUM;
    private int x;
    private int y;
    private int z;

    protected ChunkGenMysterium(World world) {
        this.world = world;
        this.rand = new Random(world.func_72905_C());
        this.world.func_181544_b(0);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.primer = new ChunkPrimer();
        this.setBlocksInChunk();
        Chunk chunk = new Chunk(this.world, this.primer, chunkX, chunkZ);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biome);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void setBlocksInChunk() {
        int x;
        boolean isHole = this.rand.nextInt(3) == 0;
        IBlockState stone = BlockRegister.MYSTERIUM_STONE.func_176223_P();
        IBlockState dirt = BlockRegister.MYSTERIUM_DIRT.func_176223_P();
        IBlockState grass = BlockRegister.MYSTERIUM_GRASS.func_176223_P();
        if (isHole) {
            this.setAllBlocksInRegion(0, 1, 0, 15, 10, 15, stone);
            this.setAllBlocksInRegion(0, 11, 0, 15, 12, 15, Blocks.field_150355_j.func_176223_P());
        } else {
            int z;
            this.setAllBlocksInRegion(0, 1, 0, 15, 20, 15, stone);
            this.setAllBlocksInRegion(0, 21, 0, 15, 21, 15, dirt);
            for (x = 0; x <= 15; ++x) {
                for (z = 0; z <= 15; ++z) {
                    if (x == 0 || x == 15 || z == 0 || z == 15) {
                        this.primer.func_177855_a(x, 22, z, grass);
                        continue;
                    }
                    this.primer.func_177855_a(x, 22, z, dirt);
                }
            }
            for (x = 1; x <= 14; ++x) {
                for (z = 1; z <= 14; ++z) {
                    if (x == 1 || x == 14 || z == 1 || z == 14) {
                        this.primer.func_177855_a(x, 23, z, grass);
                        continue;
                    }
                    this.primer.func_177855_a(x, 23, z, dirt);
                }
            }
            this.setAllBlocksInRegion(2, 24, 2, 13, 24, 13, grass);
        }
        for (x = 0; x <= 15; ++x) {
            for (int y = 0; y <= 5; ++y) {
                for (int z = 0; z <= 15; ++z) {
                    if (y > 2) continue;
                    this.primer.func_177855_a(x, y, z, BlockRegister.DIMENSIONAL_FABRIC.func_176223_P());
                }
            }
        }
    }

    private void setAllBlocksInRegion(int lowerX, int lowerY, int lowerZ, int upperX, int upperY, int upperZ, IBlockState block) {
        this.x = lowerX;
        while (this.x <= upperX) {
            this.y = lowerY;
            while (this.y <= upperY) {
                this.z = lowerZ;
                while (this.z <= upperZ) {
                    this.primer.func_177855_a(this.x, this.y, this.z, block);
                    ++this.z;
                }
                ++this.y;
            }
            ++this.x;
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int y;
        int z;
        int x;
        this.rand.setSeed(this.world.func_72905_C());
        long a = this.rand.nextLong() / 2L * 2L + 1L;
        long b = this.rand.nextLong() / 2L * 2L + 1L;
        int baseX = chunkX * 16 + 1;
        int baseZ = chunkZ * 16 + 1;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos basePos = new BlockPos(baseX, 0, baseZ);
        Biome biome = this.world.func_180494_b(basePos);
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        if (ConfigurationUtil.StructureConfig.mysterium.hauntedCastleSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.mysterium.hauntedCastleSpawnChance) == 0) {
            x = baseX;
            z = baseZ;
            y = this.world.func_189649_b(x + 19, z + 14);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 19, y - 1, z + 14)) == biome.field_76752_A) {
                StructuresHandler.generateStructure("HauntedCastle", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y - 1, z));
            }
        } else if (ConfigurationUtil.StructureConfig.mysterium.fungshroomSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.mysterium.fungshroomSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(13);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, (y = this.world.func_189649_b(x + 8, (z = baseZ + this.rand.nextInt(13)) + 8)) - 1, z + 8)) == biome.field_76752_A) {
                StructuresHandler.generateStructure("Fungshroom", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y - 1, z));
            }
        } else if (ConfigurationUtil.StructureConfig.mysterium.gorbVillageSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.mysterium.gorbVillageSpawnChance) == 0) {
            x = baseX;
            z = baseZ + this.rand.nextInt(10);
            y = this.world.func_189649_b(x + 22, z + 10);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 22, y - 1, z + 10)) == biome.field_76752_A) {
                StructuresHandler.generateStructure("GorbVillage", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y - 1, z));
            }
        } else if (ConfigurationUtil.StructureConfig.mysterium.mysticLottoShroomSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.mysterium.mysticLottoShroomSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(16);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 4, (y = this.world.func_189649_b(x + 4, (z = baseZ + this.rand.nextInt(16)) + 4)) - 1, z + 4)) == biome.field_76752_A) {
                StructuresHandler.generateStructure("MysticLottoShroom", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.mysterium.mushroomSpiderCaveSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.mysterium.mushroomSpiderCaveSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(15);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 7, (y = this.world.func_189649_b(x + 7, (z = baseZ + this.rand.nextInt(15)) + 7)) - 1, z + 7)) == biome.field_76752_A) {
                StructuresHandler.generateStructure("MushroomSpiderCave", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.mysterium.mysticPortalPlatformSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.mysterium.mysticPortalPlatformSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(16);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 6, (y = this.world.func_189649_b(x + 6, (z = baseZ + this.rand.nextInt(16)) + 4)) - 1, z + 4)) == biome.field_76752_A) {
                StructuresHandler.generateStructure("MysticPortalPlatform", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y - 1, z));
            }
        } else if (ConfigurationUtil.StructureConfig.mysterium.runicArenaSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.mysterium.runicArenaSpawnChance) == 0 && this.world.func_180495_p((BlockPos)pos.func_181079_c((x = baseX + this.rand.nextInt(16)) + 7, (y = this.world.func_189649_b(x + 7, (z = baseZ + this.rand.nextInt(16)) + 7)) - 1, z + 7)) == biome.field_76752_A) {
            StructuresHandler.generateStructure("RunicArena", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
        }
        if (ConfigurationUtil.StructureConfig.mysterium.distortionRuneShrineSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.mysterium.distortionRuneShrineSpawnChance) == 0 && this.world.func_180495_p((BlockPos)pos.func_181079_c(x = baseX + this.rand.nextInt(16), y = this.world.func_189649_b(x + 3, (z = baseZ + this.rand.nextInt(16)) + 3) + 15, z)).func_177230_c() == Blocks.field_150350_a) {
            StructuresHandler.generateStructure("DistortionRuneShrine", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
        }
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        biome.func_180624_a(this.world, this.rand, basePos);
        WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(baseX + 8), (int)(baseZ + 8), (int)16, (int)16, (Random)this.rand);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

