/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.voxponds.biomes;

import java.awt.Color;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.AoAStructure;
import net.tslat.aoa3.structure.StructuresHandler;

public class BiomeVoxPonds
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Vox Ponds");

    public BiomeVoxPonds() {
        super(properties);
        this.setRegistryName("aoa3", "vox_ponds");
        this.field_76752_A = BlockRegister.getUnmappedBlock("toxic_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("toxic_dirt").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeVoxPondsDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.WET, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DEAD});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.GREEN.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.0f);
        properties.func_185395_b(0.0f);
        properties.func_185402_a(new Color(103, 147, 0).getRGB());
        properties.func_185396_a();
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.1f);
    }

    public class BiomeVoxPondsDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (!rand.nextBoolean() || world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x, 38, basePos.func_177952_p() + z)) != biome.field_76752_A) continue;
                    world.func_175656_a(pos.func_177984_a(), BlockRegister.DEAD_GRASS.func_176223_P());
                }
            }
            for (int i = 0; i < 3; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = 39) - 1, posZ = basePos.func_177952_p() + rand.nextInt(16))) != biome.field_76752_A || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue;
                world.func_175656_a(pos.func_177984_a(), BlockRegister.VOX_SHROOM.func_176223_P());
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            block5: for (int i = 0; i < rand.nextInt(3); ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                posZ = basePos.func_177952_p() + rand.nextInt(16);
                posY = 39;
                switch (rand.nextInt(3)) {
                    case 0: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4)) != biome.field_76752_A || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block5;
                        StructuresHandler.generateStructure("ToxicTree1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block5;
                    }
                    case 1: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)) != biome.field_76752_A || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block5;
                        StructuresHandler.generateStructure("ToxicTree2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block5;
                    }
                    case 2: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)) != biome.field_76752_A || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block5;
                        StructuresHandler.generateStructure("ToxicTree3", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }

        @Override
        protected void doMiscGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            int i;
            block13: for (i = 0; i < 12; ++i) {
                switch (rand.nextInt(5)) {
                    case 0: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = 39;
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)) != biome.field_76752_A || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block13;
                        StructuresHandler.generateStructure("ToxicTentacle1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block13;
                    }
                    case 1: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = 39;
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)) != biome.field_76752_A || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block13;
                        StructuresHandler.generateStructure("ToxicTentacle2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block13;
                    }
                    case 2: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = 39;
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)) != biome.field_76752_A || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block13;
                        StructuresHandler.generateStructure("ToxicTentacle3", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block13;
                    }
                    case 3: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = 39;
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 1)) != biome.field_76752_A || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block13;
                        StructuresHandler.generateStructure("ToxicTentacle4", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block13;
                    }
                    case 4: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = 39;
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 1)) != biome.field_76752_A || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue block13;
                        StructuresHandler.generateStructure("ToxicTentacle5", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
            for (i = 0; i < 6; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = 39) - 1, posZ = basePos.func_177952_p() + rand.nextInt(16))) != biome.field_76752_A || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue;
                if (rand.nextBoolean()) {
                    StructuresHandler.generateStructure("VoxBranch1", world, rand, pos.func_177984_a());
                    continue;
                }
                StructuresHandler.generateStructure("VoxBranch2", world, rand, pos.func_177984_a());
            }
            for (i = 0; i < 8; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = 38) - 1, posZ = basePos.func_177952_p() + rand.nextInt(16))).func_177230_c() != BlockRegister.TOXIC_WASTE) continue;
                StructuresHandler.generateStructure("MiniTentacles", world, rand, pos.func_177984_a());
            }
            if (rand.nextInt(16) == 0) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                posZ = basePos.func_177952_p() + rand.nextInt(16);
                posY = 16;
                if (rand.nextBoolean()) {
                    StructuresHandler.generateStructure("DegradedSupportBeam1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                } else {
                    StructuresHandler.generateStructure("DegradedSupportBeam2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
            for (i = 0; i < rand.nextInt(6) + 2; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                posZ = basePos.func_177952_p() + rand.nextInt(16);
                posY = 28;
                AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
                switch (rand.nextInt(4)) {
                    case 0: {
                        structure = StructuresHandler.getStructure("ToxicStem1");
                        break;
                    }
                    case 1: {
                        structure = StructuresHandler.getStructure("ToxicStem2");
                        break;
                    }
                    case 2: {
                        structure = StructuresHandler.getStructure("ToxicStem3");
                        break;
                    }
                    case 3: {
                        structure = StructuresHandler.getStructure("ToxicStem4");
                    }
                }
                StructuresHandler.generateStructure(structure, world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
            }
        }
    }
}

