/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.baroness;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.boss.baroness.EntityBaroness;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class EntityBaronBomb
extends Entity {
    private int timer = 150;
    private UUID ownerUUID = null;
    private EntityPlayer ownerPlayer = null;
    private EntityBaroness baroness = null;

    public EntityBaronBomb(EntityPlayer pl) {
        this(pl.field_70170_p);
        this.ownerUUID = pl.func_110124_au();
        this.func_70634_a(pl.field_70165_t, pl.field_70163_u, pl.field_70161_v);
    }

    public EntityBaronBomb(EntityBaroness baroness) {
        this(baroness.field_70170_p);
        this.baroness = baroness;
        this.func_70634_a(baroness.field_70165_t, baroness.field_70163_u, baroness.field_70161_v);
    }

    public float func_70047_e() {
        return 0.25f;
    }

    public EntityBaronBomb(World world) {
        super(world);
        this.func_70105_a(1.0f, 0.8125f);
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public boolean func_70104_M() {
        return !this.field_70128_L;
    }

    protected void func_70088_a() {
    }

    public void func_70100_b_(EntityPlayer entity) {
        if (!this.field_70170_p.field_72995_K && this.checkEntityCollision((Entity)entity)) {
            if (this.ownerUUID == null) {
                WorldUtil.createExplosion((Entity)this.baroness, this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 3.5f, WorldUtil.checkGameRule(this.field_70170_p, "doStrongerMobGriefing"), false);
            } else {
                WorldUtil.createExplosion((Entity)this.ownerPlayer, this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 2.0f);
            }
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70108_f(Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.checkEntityCollision(entity)) {
            if (this.ownerPlayer != null) {
                WorldUtil.createExplosion((Entity)this.ownerPlayer, this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 2.0f);
            } else {
                WorldUtil.createExplosion((Entity)this.baroness, this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 3.5f, WorldUtil.checkGameRule(this.field_70170_p, "doStrongerMobGriefing"), false);
            }
            this.func_70106_y();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            if (!source.func_94541_c() && source.func_76346_g() != this.baroness && source.func_76346_g() != this.ownerPlayer) {
                if (this.ownerPlayer != null) {
                    WorldUtil.createExplosion((Entity)this.ownerPlayer, this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 2.0f);
                } else {
                    WorldUtil.createExplosion((Entity)this.baroness, this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 3.5f, WorldUtil.checkGameRule(this.field_70170_p, "doStrongerMobGriefing"), false);
                }
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_85031_j(Entity attacker) {
        if (!this.field_70170_p.field_72995_K && this.checkEntityCollision(attacker)) {
            this.func_70106_y();
        }
        return true;
    }

    private boolean checkEntityCollision(Entity target) {
        UUID ownerUUID;
        if (this.ownerUUID == null) {
            return !(target instanceof EntityBaroness);
        }
        if (target instanceof EntityPlayer) {
            this.updateOwner();
            if (this.ownerPlayer != null && !EntityUtil.canPvp(this.ownerPlayer, (EntityPlayer)target)) {
                return false;
            }
        } else if (target instanceof EntityTameable && (ownerUUID = ((EntityTameable)target).func_184753_b()) != null && ownerUUID.equals(this.ownerUUID)) {
            return false;
        }
        return true;
    }

    private void updateOwner() {
        this.ownerPlayer = this.ownerPlayer == null ? this.field_70170_p.func_73046_m().func_184103_al().func_177451_a(this.ownerUUID) : this.ownerPlayer;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        BlockPos pos = new BlockPos(this.field_70165_t, 0.0, this.field_70161_v);
        if (!this.field_70170_p.field_72995_K || this.field_70170_p.func_175667_e(pos) && this.field_70170_p.func_175726_f(pos).func_177410_o()) {
            if (!this.func_189652_ae()) {
                this.field_70181_x -= 0.08;
            }
        } else {
            this.field_70181_x = this.field_70163_u > 0.0 ? -0.1 : 0.0;
        }
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.field_70170_p.field_72995_K) {
            if (this.ownerUUID == null && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                this.func_70106_y();
                return;
            }
            --this.timer;
            if (this.timer == 16) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.BARON_BOMB_PRIMING, SoundCategory.HOSTILE, 1.0f, 1.0f);
            } else if (this.timer <= 0) {
                this.updateOwner();
                if (this.ownerPlayer != null) {
                    WorldUtil.createExplosion((Entity)this.ownerPlayer, this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 2.0f);
                } else {
                    WorldUtil.createExplosion((Entity)this.baroness, this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 4.0f);
                }
                this.func_70106_y();
            }
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }
}

