/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.coniferon;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.tslat.aoa3.common.packet.PacketScreenOverlay;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.PacketUtil;

public class EntityConiferon
extends AoAMeleeMob
implements BossEntity,
SpecialPropertyEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/coniferon.png");
    public static final float entityWidth = 1.5f;

    public EntityConiferon(World world) {
        super(world, 1.5f, 6.375f);
        this.mobProperties.add(Enums.MobProperties.GUN_IMMUNE);
    }

    public float func_70047_e() {
        return 3.625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.3;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 4000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 25.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_CONIFERON_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_CONIFERON_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_CONIFERON_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityConiferon;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isGunDamage(source);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        EntityLivingBase target = this.func_70638_az();
        if (target == null) {
            return;
        }
        if (this.field_70146_Z.nextInt(300) == 0) {
            if (!this.field_70170_p.field_72995_K) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 60, 0, true, true));
            }
            if (target instanceof EntityPlayerMP) {
                PacketUtil.network.sendTo((IMessage)new PacketScreenOverlay(70, Enums.ScreenOverlays.CONIFERON_VINES), (EntityPlayerMP)target);
            }
        }
        if (!target.func_70093_af()) {
            target.func_70024_g(Math.signum(this.field_70165_t - target.field_70165_t) * 0.029, 0.0, Math.signum(this.field_70161_v - target.field_70161_v) * 0.029);
        }
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (target instanceof EntityLivingBase) {
            double resist = 1.0;
            IAttributeInstance attrib = ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c);
            if (attrib != null) {
                resist -= attrib.func_111126_e();
            }
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 140, 2, true, true));
            target.func_70024_g(this.field_70159_w * 10.5 * resist, this.field_70181_x * 0.5 * resist, this.field_70179_y * 10.5 * resist);
            target.field_70133_I = true;
        }
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.CONIFERON_MUSIC;
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

