/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.cottoncandor;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.common.registration.WeaponRegister;
import net.tslat.aoa3.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityCottonCandorShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityBaronShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityFireflyShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityFirestormFall;
import net.tslat.aoa3.entity.projectiles.staff.EntityNoxiousShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityPoisonShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityPrimordialShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityWaterShot;
import net.tslat.aoa3.entity.projectiles.staff.EntityWitherShot;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ModUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class EntityCottonCandor
extends AoAFlyingRangedMob
implements SpecialPropertyEntity,
BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/cotton_candor.png");
    public static final float entityWidth = 1.5f;
    private static final DataParameter<Byte> STAGE = EntityDataManager.func_187226_a(EntityCottonCandor.class, (DataSerializer)DataSerializers.field_187191_a);
    private int stageCountdown = 100;

    public EntityCottonCandor(World world) {
        super(world, 1.5f, 2.375f);
        this.mobProperties.add(Enums.MobProperties.SPECIAL_COMBAT_ENTITY);
    }

    public float func_70047_e() {
        return 1.71875f;
    }

    @Override
    public PathNavigate func_70661_as() {
        return new PathNavigateFlying((EntityLiving)this, this.field_70170_p);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STAGE, (Object)0);
    }

    private void changeStage(int stage) {
        this.field_70180_af.func_187227_b(STAGE, (Object)((byte)(stage & 7)));
    }

    public int getStage() {
        return ((Byte)this.field_70180_af.func_187225_a(STAGE)).byteValue();
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 3000.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 35.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_COTTON_CANDOR_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_COTTON_CANDOR_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_COTTON_CANDOR_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityCottonCandor;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        if (source.func_76364_f() instanceof IProjectile) {
            IProjectile projectile = (IProjectile)source.func_76364_f();
            switch (this.getStage()) {
                case 0: {
                    if (!(projectile instanceof EntityPrimordialShot)) break;
                    return false;
                }
                case 1: {
                    if (!(projectile instanceof EntityWaterShot)) break;
                    return false;
                }
                case 2: {
                    if (!(projectile instanceof EntityFirestormFall) && !(projectile instanceof EntityFireflyShot) && !(projectile instanceof EntityBaronShot)) break;
                    return false;
                }
                case 3: {
                    if (!(projectile instanceof EntityPoisonShot) && !(projectile instanceof EntityNoxiousShot)) break;
                    return false;
                }
                case 4: {
                    if (!(projectile instanceof EntityWitherShot)) break;
                    return false;
                }
                default: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundsRegister.COTTON_CANDOR_SHOOT;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityCottonCandorShot(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            --this.stageCountdown;
            if (this.stageCountdown == 0) {
                this.changeStage(this.field_70146_Z.nextInt(5));
                this.stageCountdown = 100;
            }
        }
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 5.0f);
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, IBlockState blockHit, BlockPos pos, EnumFacing sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 5.0f);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                    if (source instanceof EntityPlayerMP && cause.func_76364_f() instanceof EntityPrimordialShot && (killer.func_184614_ca().func_77973_b() == WeaponRegister.WIND_STAFF || killer.func_184592_cb().func_77973_b() == WeaponRegister.WIND_STAFF)) {
                        ModUtil.completeAdvancement((EntityPlayerMP)killer, "candyland/when_push_comes_to_shove", "wind_staff_kill");
                    }
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.cottonCandor.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    @Nonnull
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.COTTON_CANDOR_MUSIC;
    }

    @Override
    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

