/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.craexxeus;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.boss.craexxeus.EntityCraexxeus;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.utils.StringUtil;

public class EntityXxeus
extends AoAMeleeMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/xxeus.png");
    public static final float entityWidth = 1.0f;
    private int jumpCooldown = 60;

    public EntityXxeus(EntityCraexxeus craexxeus) {
        this(craexxeus.field_70170_p);
        this.func_70012_b(craexxeus.field_70165_t, craexxeus.field_70163_u + 1.0, craexxeus.field_70161_v, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
    }

    public EntityXxeus(World world) {
        super(world, 1.0f, 3.125f);
        this.setSlipperyMovement();
        this.func_70659_e(2.1f);
    }

    public float func_70047_e() {
        return 2.55f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 3000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 25.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.329;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_XXEUS_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_XXEUS_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_XXEUS_HIT;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.ENTITY_GENERIC_HEAVY_STEP;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityXxeus;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return null;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null) {
            if (this.jumpCooldown > 0) {
                --this.jumpCooldown;
            } else {
                this.jumpCooldown = 60;
                EntityLivingBase target = this.func_70638_az();
                this.field_70159_w = (target.field_70165_t - this.field_70165_t) * 0.165;
                this.field_70181_x = target.field_70163_u > this.field_70163_u ? 0.85 : 0.449;
                this.field_70179_y = (target.field_70161_v - this.field_70161_v) * 0.165;
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.MOB_XXEUS_DASH, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && !this.func_175446_cd()) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.xxeus.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

