/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.creep;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityCreepBomb;
import net.tslat.aoa3.entity.projectiles.mob.EntityCreepTube;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class EntityCreep
extends AoARangedMob
implements BossEntity,
SpecialPropertyEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/creep.png");
    public static final float entityWidth = 0.7f;

    public EntityCreep(World world) {
        super(world, 0.7f, 1.75f);
        this.mobProperties.add(Enums.MobProperties.EXPLOSION_IMMUNE);
    }

    public float func_70047_e() {
        return 1.53125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 3000.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 6.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.23;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_CREEPOID_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_CREEPOID_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_CREEPOID_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityCreep;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityCreepTube(this, Enums.MobProjectileType.OTHER);
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return source.func_94541_c();
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_175446_cd() || this.field_70128_L) {
            return;
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            EntityCreepBomb creepBomb = new EntityCreepBomb(this, Enums.MobProjectileType.OTHER);
            creepBomb.func_70186_c(1 / (this.field_70146_Z.nextInt(15) + 1) * (1 - this.field_70146_Z.nextInt(3)), 4.3f, 1 / (this.field_70146_Z.nextInt(15) + 1) * (1 - this.field_70146_Z.nextInt(3)), 1.6f, 12.0f);
            this.field_70170_p.func_72838_d((Entity)creepBomb);
        }
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (projectile instanceof EntityCreepBomb) {
            if (target.func_70097_a(DamageSource.func_188403_a((Entity)projectile, (EntityLivingBase)this), (float)this.getBaseProjectileDamage() * 2.5f)) {
                this.doProjectileImpactEffect(projectile, target);
            }
        } else {
            super.doProjectileEntityImpact(projectile, target);
        }
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 1.2f);
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, IBlockState blockHit, BlockPos pos, EnumFacing sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 1.2f);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.creep.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    @Nonnull
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.CREEP_MUSIC;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

