/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.elusive;

import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.boss.elusive.EntityElusiveClone;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.utils.ModUtil;
import net.tslat.aoa3.utils.StringUtil;

public class EntityElusive
extends AoAMeleeMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/elusive.png");
    public static final float entityWidth = 0.7f;
    private final HashSet<EntityElusiveClone> summons = new HashSet();
    private int summonCooldown = 300;
    private int teleportCooldown = 300;

    public EntityElusive(World world) {
        super(world, 0.7f, 1.625f);
    }

    public float func_70047_e() {
        return 1.5f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 15.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_ELUSIVE_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_ELUSIVE_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_ELUSIVE_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityElusive;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.summonCooldown > 0) {
                --this.summonCooldown;
            } else {
                this.summonCooldown = 300;
                EntityElusiveClone clone = new EntityElusiveClone(this);
                this.field_70170_p.func_72838_d((Entity)clone);
                this.summons.add(clone);
            }
            if (this.teleportCooldown > 0) {
                --this.teleportCooldown;
            } else if (this.func_70638_az() != null) {
                double z;
                double y;
                this.teleportCooldown = 300;
                Vec3d targetLookVec = new Vec3d(this.field_70165_t - this.func_70638_az().field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e(), this.field_70161_v - this.func_70638_az().field_70161_v).func_72432_b();
                double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - targetLookVec.field_72450_a * 16.0;
                if (!this.field_70170_p.func_180495_p(new BlockPos(x, y = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - targetLookVec.field_72448_b * 16.0, z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - targetLookVec.field_72449_c * 16.0)).func_185914_p() && !this.field_70170_p.func_180495_p(new BlockPos(x, y + 1.0, z)).func_185914_p()) {
                    this.func_70634_a(x, y, z);
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                    if (killer instanceof EntityPlayerMP && killer.func_70644_a(MobEffects.field_76441_p)) {
                        boolean armourless = true;
                        for (ItemStack stack : killer.func_184193_aE()) {
                            if (stack.func_77973_b() == Items.field_190931_a) continue;
                            armourless = false;
                        }
                        if (armourless) {
                            ModUtil.completeAdvancement((EntityPlayerMP)killer, "abyss/activated_my_trap_card", "invisible_kill");
                        }
                    }
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.elusive.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
            for (EntityElusiveClone summon : this.summons) {
                if (summon == null) continue;
                summon.func_70106_y();
            }
        }
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.ELUSIVE_MUSIC;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

