/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.fourguardians;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.boss.fourguardians.EntityGreenGuardian;
import net.tslat.aoa3.entity.boss.fourguardians.EntityRedGuardian;
import net.tslat.aoa3.entity.boss.fourguardians.EntityYellowGuardian;
import net.tslat.aoa3.entity.minions.AoAMinion;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityBlueGuardianShot;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ModUtil;

public class EntityBlueGuardian
extends AoARangedMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/blue_guardian.png");
    public static final float entityWidth = 1.5f;
    private EntityRedGuardian redGuardian;
    private EntityGreenGuardian greenGuardian;
    private EntityYellowGuardian yellowGuardian;

    public EntityBlueGuardian(World world) {
        super(world, 1.5f, 2.625f);
    }

    public float func_70047_e() {
        return 1.875f;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 25, 50, 32.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, AoAMinion.class, 10, true, false, minion -> minion.func_70909_n()));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 750.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 20.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_GUARDIAN_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_GUARDIAN_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundsRegister.GUARDIAN_SHOOT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.checkGuardian((EntityLivingBase)this.redGuardian) && this.checkGuardian((EntityLivingBase)this.greenGuardian) && this.checkGuardian((EntityLivingBase)this.yellowGuardian)) {
            return LootSystemRegister.entityBlueGuardian;
        }
        return null;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void setGreenGuardian(EntityGreenGuardian greenGuardian) {
        this.greenGuardian = greenGuardian;
    }

    public void setRedGuardian(EntityRedGuardian redGuardian) {
        this.redGuardian = redGuardian;
    }

    public void setYellowGuardian(EntityYellowGuardian yellowGuardian) {
        this.yellowGuardian = yellowGuardian;
    }

    private boolean checkGuardian(EntityLivingBase guardian) {
        return guardian == null || guardian.field_70128_L || guardian.func_110143_aJ() == 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic(null);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            if (this.checkGuardian((EntityLivingBase)this.yellowGuardian) && this.checkGuardian((EntityLivingBase)this.greenGuardian) && this.checkGuardian((EntityLivingBase)this.redGuardian)) {
                for (EntityPlayerMP pl : this.field_70170_p.func_72872_a(EntityPlayerMP.class, this.func_174813_aQ().func_186662_g(20.0))) {
                    ModUtil.completeAdvancement(pl, "haven/guard_that", "kill_four_guardians");
                }
            }
        }
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (target instanceof AoARangedMob && target instanceof BossEntity) {
            return;
        }
        super.doProjectileEntityImpact(projectile, target);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        if (target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 40, 2, true, true));
        }
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityBlueGuardianShot(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.FOUR_GUARDIANS_MUSIC;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

