/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.rockrider;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.StringUtil;

public class EntityRockRider
extends AoAMeleeMob
implements BossEntity,
SpecialPropertyEntity {
    private static final DataParameter<Boolean> ALTERNATE_FORM = EntityDataManager.func_187226_a(EntityRockRider.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/rock_rider.png");
    public static final float entityWidth = 1.3f;
    private boolean alternateForm = false;
    private int formCooldown = 300;

    public EntityRockRider(World world) {
        super(world, 1.3f, 3.375f);
        this.mobProperties.add(Enums.MobProperties.MELEE_IMMUNE);
        this.setSlipperyMovement();
        this.func_70659_e(0.8f);
    }

    public float func_70047_e() {
        return 3.0625f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ALTERNATE_FORM, (Object)false);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.9;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1500.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 30.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.329;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_ROCK_RIDER_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_ROCK_RIDER_HIT;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.ENTITY_GENERIC_HEAVY_STEP;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityRockRider;
    }

    public boolean func_184222_aU() {
        return false;
    }

    private void changeForm(boolean alternate) {
        if (alternate) {
            this.mobProperties.add(Enums.MobProperties.GUN_IMMUNE);
            this.mobProperties.remove((Object)Enums.MobProperties.MELEE_IMMUNE);
            this.formCooldown = 300;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_187227_b(ALTERNATE_FORM, (Object)true);
            }
        } else {
            this.mobProperties.add(Enums.MobProperties.MELEE_IMMUNE);
            this.mobProperties.remove((Object)Enums.MobProperties.GUN_IMMUNE);
            this.formCooldown = 300;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_187227_b(ALTERNATE_FORM, (Object)false);
            }
        }
    }

    public boolean isAlternateForm() {
        return (Boolean)this.field_70180_af.func_187225_a(ALTERNATE_FORM);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.formCooldown > 0) {
            --this.formCooldown;
        } else if (this.alternateForm) {
            this.alternateForm = false;
            this.changeForm(false);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.MOB_ROCK_RIDER_SWITCH, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
        } else {
            this.alternateForm = true;
            this.changeForm(true);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.MOB_ROCK_RIDER_SWITCH, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
        }
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return this.alternateForm ? EntityUtil.isGunDamage(source) : EntityUtil.isMeleeDamage(source);
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (target instanceof EntityLivingBase) {
            if (this.alternateForm) {
                double resist = 1.0;
                IAttributeInstance attrib = ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c);
                if (attrib != null) {
                    resist -= attrib.func_111126_e();
                }
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 150, 3, true, true));
                target.func_70024_g(this.field_70159_w * 5.0 * resist, this.field_70181_x * resist, this.field_70179_y * 5.0 * resist);
                target.field_70133_I = true;
            } else {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 150, 3, true, true));
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.rockrider.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.ROCK_RIDER_MUSIC;
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

