/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.minions;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.utils.skills.HunterUtil;

public abstract class AoAMinion
extends EntityTameable {
    private final int lifespan;
    private int animationTicks = 0;
    protected String currentAnimation = null;

    public AoAMinion(World world, int tickLifespan, float entityWidth, float entityHeight) {
        super(world);
        this.lifespan = tickLifespan;
        this.func_70105_a(entityWidth, entityHeight);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.lifespan > 0 && this.field_70173_aa >= this.lifespan) {
            this.func_70106_y();
        }
        if (this.animationTicks >= 0) {
            ++this.animationTicks;
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 30.0f, this.lifespan == -1 ? 2.0f : 100.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        if (this.isHostile()) {
            if (this.getBaseMeleeDamage() >= 0.0) {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.5, true));
                this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.3f));
                this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, (double)0.8f, 16.0f));
            }
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, false, IMob.field_82192_a));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        }
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> clazz) {
        return !AoAMinion.class.isAssignableFrom(clazz);
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        EntityLivingBase owner;
        if (target != null && (owner = this.func_70902_q()) instanceof EntityPlayer && !HunterUtil.doesPlayerMeetHunterReq(target, (EntityPlayer)owner)) {
            return;
        }
        super.func_70624_b(target);
    }

    public void func_70604_c(@Nullable EntityLivingBase target) {
        EntityLivingBase owner;
        if (target != null && (owner = this.func_70902_q()) instanceof EntityPlayer && !HunterUtil.doesPlayerMeetHunterReq(target, (EntityPlayer)owner)) {
            return;
        }
        super.func_70604_c(target);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth());
        if (this.isHostile()) {
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getBaseMeleeDamage());
        }
    }

    protected double getBaseMoveSpeed() {
        return 0.25;
    }

    protected abstract double getBaseMaxHealth();

    protected double getBaseMeleeDamage() {
        return -1.0;
    }

    protected abstract boolean isHostile();

    @Nullable
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187655_bw : SoundEvents.field_187545_bE;
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        if (entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()))) {
            this.func_130011_c(entity);
            return true;
        }
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || this.func_184753_b() != null && source.func_76346_g() != null && source.func_76346_g().func_110124_au().equals(this.func_184753_b());
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }
}

