/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.misc.pixon;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.tool.misc.InfusionBowl;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.player.PlayerUtil;

public abstract class EntityPixon
extends EntityCreature {
    public static final float entityWidth = 0.9f;
    public long nextHarvestTick = 0L;

    public EntityPixon(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.3f);
        this.field_70178_ae = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.55));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(15 + this.field_70146_Z.nextInt(30)));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.40000000298023225);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public void func_70690_d(PotionEffect effect) {
    }

    public boolean func_184603_cC() {
        return false;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return forSpawnCount ? type == EnumCreatureType.AMBIENT : type == EnumCreatureType.CREATURE;
    }

    protected void func_82167_n(Entity entity) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        ItemStack heldStack = player.func_184586_b(hand);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() >= this.nextHarvestTick && heldStack.func_77973_b() instanceof InfusionBowl) {
            InfusionBowl bowl = (InfusionBowl)heldStack.func_77973_b();
            if (player.field_71075_bZ.field_75098_d || PlayerUtil.doesPlayerHaveLevel(player, Enums.Skills.INFUSION, this.getHarvestLevelReq() + bowl.getHarvestReqModifier())) {
                bowl.handlePixonHarvest(player, this, heldStack);
            } else if (player instanceof EntityPlayerMP) {
                PlayerUtil.notifyPlayerOfInsufficientLevel((EntityPlayerMP)player, Enums.Skills.INFUSION, this.getHarvestLevelReq() + bowl.getHarvestReqModifier());
            }
            if (this.func_110143_aJ() <= 0.0f) {
                player.func_191956_a((Entity)this, 1, DamageSource.field_76377_j);
            } else {
                this.nextHarvestTick = this.field_70170_p.func_82737_E() + 8L + (long)this.field_70146_Z.nextInt(32);
            }
            return true;
        }
        return false;
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.func_175624_G() == WorldType.field_77138_c) {
            return false;
        }
        BlockPos position = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Biome biome = this.field_70170_p.func_180494_b(position);
        IBlockState blockState = this.field_70170_p.func_180495_p(position);
        return blockState == biome.field_76752_A && blockState.func_189884_a((Entity)this);
    }

    public boolean func_190530_aW() {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return source != DamageSource.field_76380_i;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public float func_70047_e() {
        return 0.65f;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.ENTITY_PIXON_LIVING;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return null;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    public abstract int getHarvestLevelReq();

    @Nonnull
    public abstract ResourceLocation getHarvestLootTable();
}

