/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.misc.tablet;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.item.tablet.TabletItem;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.player.PlayerUtil;
import org.apache.logging.log4j.Level;

public abstract class EntitySoulTablet
extends Entity {
    private static final DataParameter<Boolean> ACTIVE = EntityDataManager.func_187226_a(EntitySoulTablet.class, (DataSerializer)DataSerializers.field_187198_h);
    protected EntityPlayer owner = null;
    private UUID ownerUUID = null;

    public EntitySoulTablet(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.09375f);
        this.field_70156_m = true;
    }

    public EntitySoulTablet(World world, EntityPlayer placer) {
        this(world);
        this.owner = placer;
        this.ownerUUID = this.owner != null ? this.owner.func_110124_au() : null;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ACTIVE, (Object)true);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return this.ownerUUID == null || player.func_110124_au().equals(this.ownerUUID);
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        if (!this.field_70128_L && (this.ownerUUID == null || player.func_110124_au().equals(this.ownerUUID))) {
            if (!this.field_70170_p.field_72995_K && !player.func_184812_l_()) {
                ItemStack stack = new ItemStack((Item)this.getRelevantItem());
                if (player.func_184586_b(hand).func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack((Item)this.getRelevantItem()));
                } else if (!player.func_191521_c(stack)) {
                    this.func_70099_a(stack, 0.0f);
                }
            }
            this.func_70106_y();
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.owner != null) {
            compound.func_74778_a("OwnedBy", this.ownerUUID.toString());
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("OwnedBy")) {
            try {
                this.ownerUUID = UUID.fromString(compound.func_74779_i("OwnedBy"));
                this.owner = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.ownerUUID);
            }
            catch (IllegalArgumentException e) {
                AdventOfAscension.logMessage(Level.WARN, "Unknown or malformed owner UUID for soul tablet entity: " + compound.func_74779_i("OwnerBy"));
            }
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (!this.field_70128_L && this.field_70173_aa % 5 == 0) {
                if (this.field_70170_p.func_175623_d(this.func_180425_c().func_177977_b())) {
                    EntityItem itemDrop = this.func_70099_a(new ItemStack((Item)this.getRelevantItem()), 0.0f);
                    if (this.owner != null && itemDrop != null) {
                        itemDrop.func_145797_a(this.owner.func_70005_c_());
                    }
                    this.func_70106_y();
                    return;
                }
                if (this.isActive()) {
                    if (this.testSoulSupply()) {
                        this.doTickEffect();
                    } else {
                        this.deactivate();
                    }
                }
            }
        } else if (this.field_70170_p.func_175623_d(this.func_180425_c().func_177977_b())) {
            this.func_70106_y();
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return source != DamageSource.field_76380_i;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
    }

    protected abstract void doTickEffect();

    public abstract TabletItem getRelevantItem();

    private boolean testSoulSupply() {
        if (this.owner == null) {
            return false;
        }
        return PlayerUtil.consumeResource(this.owner, Enums.Resources.SOUL, this.getRelevantItem().getSoulDrain() * 5.0f * (PlayerUtil.isWearingFullSet(this.owner, Enums.ArmourSets.ANIMA) ? 0.5f : 1.0f), false);
    }

    public boolean isActive() {
        return (Boolean)this.field_70180_af.func_187225_a(ACTIVE);
    }

    private void deactivate() {
        this.field_70180_af.func_187227_b(ACTIVE, (Object)false);
    }

    protected <T extends Entity> List<T> getTargetsWithinRadius(Class<? extends T> targetClass, @Nullable Predicate<? super T> predicate) {
        return this.field_70170_p.func_175647_a(targetClass, this.func_174813_aQ().func_186662_g((double)this.getRelevantItem().getEffectRadius()), predicate);
    }
}

