/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.abyss;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class EntityBloodsucker
extends AoAMeleeMob {
    public static final float entityWidth = 1.3f;

    public EntityBloodsucker(World world) {
        super(world, 1.3f, 1.0f);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.3;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 109.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 8.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.295;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_BLOODSUCKER_LIVING;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_BLOODSUCKER_DEATH;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_BLOODSUCKER_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityBloodsucker;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, 2, true, false));
            this.func_70691_i((float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 2.0f);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.ancientCavern) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                PlayerUtil.addTributeToPlayer(killer, Enums.Deities.EREBON, 8);
            }
        }
    }
}

