/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.creeponia;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.mobs.creeponia.EntityCreeponiaCreeper;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityCreeperShot;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class EntityMagicalCreeper
extends EntityCreeponiaCreeper
implements AoARangedAttacker {
    public static final float entityWidth = 0.6f;

    public EntityMagicalCreeper(World world) {
        super(world, 0.6f, 2.37f);
    }

    public float func_70047_e() {
        return 1.40625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 55.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.25;
    }

    @Override
    public float getExplosionStrength() {
        return 3.0f;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_CREEPOID_LIVING;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_CREEPOID_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsRegister.MOB_CREEPOID_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityMagicalCreeper;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u < 50.0 && super.func_70601_bi();
    }

    public void func_70636_d() {
        super.func_70636_d();
        EntityPlayer target = this.field_70170_p.func_184137_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 20.0, false);
        if (target == null || target.field_71075_bZ.field_75098_d) {
            return;
        }
        if (this.field_70146_Z.nextInt(70) == 0) {
            EntityCreeperShot projectile = new EntityCreeperShot(this, Enums.MobProjectileType.MAGIC);
            double distanceFactorX = target.field_70165_t - this.field_70165_t;
            double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - projectile.field_70163_u;
            double distanceFactorZ = target.field_70161_v - this.field_70161_v;
            double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) + 0.2;
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.MAGIC_CREEPER_SHOOT, SoundCategory.HOSTILE, 1.0f, 1.0f);
            projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
            this.field_70170_p.func_72838_d((Entity)projectile);
        }
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (EntityUtil.dealBlasterDamage((EntityLivingBase)this, target, (Entity)projectile, 7.0f, false)) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, IBlockState blockHit, BlockPos pos, EnumFacing sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }
}

