/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.crystevia;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityConstructShot;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityConstructRange
extends AoARangedMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 1.7f;

    public EntityConstructRange(World world) {
        super(world, 1.7f, 1.5f);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.MAGIC_IMMUNE);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.3;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 70.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 10.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Override
    protected double getBaseArmour() {
        return 3.0;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_CRYSTAL_CONSTRUCT_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_CRYSTAL_CONSTRUCT_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_CRYSTAL_CONSTRUCT_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityConstructOfRange;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(0.1f);
        }
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityConstructShot(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isMagicDamage(source, (Entity)this, damage) || EntityUtil.isRangedDamage(source, (Entity)this, damage);
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

