/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.gardencia;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.misc.AoAAttributes;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class EntityCarrotop
extends AoAMeleeMob {
    public static final float entityWidth = 0.5625f;
    private boolean candiedWater = false;

    public EntityCarrotop(World world) {
        super(world, 0.5625f, 2.375f);
    }

    public float func_70047_e() {
        return 1.125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.15;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 85.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 9.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_CARROTOP_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_CARROTOP_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_CARROTOP_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityCarrotop;
    }

    protected void func_191955_a(IBlockState state) {
        if (state.func_177230_c() == BlockRegister.CANDIED_WATER && !this.candiedWater) {
            EntityUtil.applyAttributeModifierSafely((EntityLivingBase)this, SharedMonsterAttributes.field_111267_a, AoAAttributes.GARDENCIA_CANDIED_WATER_BUFF);
            this.func_70606_j(this.func_110143_aJ() * 1.5f);
            this.candiedWater = true;
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.candiedWater) {
            compound.func_74757_a("AoACandiedWater", true);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("AoACandiedWater")) {
            this.candiedWater = true;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP()) {
            if (this.func_70090_H()) {
                this.func_70691_i(0.2f);
            } else if (this.field_70170_p.func_175727_C(this.func_180425_c())) {
                this.func_70691_i(0.1f);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.candiedWater && cause.func_76346_g() instanceof EntityPlayer && ItemUtil.findInventoryItem((EntityPlayer)cause.func_76346_g(), new ItemStack((Item)ItemRegister.BLANK_REALMSTONE), true, 1)) {
            ItemUtil.givePlayerItemOrDrop((EntityPlayer)cause.func_76346_g(), new ItemStack((Item)ItemRegister.BOREAN_REALMSTONE));
        }
    }
}

