/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.overworld;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;

public class EntityHeadlessHunter
extends AoAMeleeMob {
    public static final float entityWidth = 1.2f;

    public EntityHeadlessHunter(World world) {
        super(world, 1.2f, 1.9f);
    }

    public float func_70047_e() {
        return 1.7f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.3f;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 40.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 8.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.25;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_SLIMER_DEATH;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_SLIMER_HIT;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.VERY_HEAVY_STEP;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityHeadlessHunter;
    }

    public void func_70074_a(EntityLivingBase victim) {
        if (victim instanceof EntityPlayer && this.field_70146_Z.nextInt(20) == 0) {
            ItemStack headStack = new ItemStack(Items.field_151144_bL, 1, 3);
            headStack.func_77982_d(new NBTTagCompound());
            headStack.func_77978_p().func_74782_a("SkullOwner", (NBTBase)new NBTTagString(((EntityPlayer)victim).func_146103_bH().getName()));
            EntityItem playerHead = new EntityItem(this.field_70170_p, victim.field_70165_t, victim.field_70163_u, victim.field_70161_v, headStack);
            this.field_70170_p.func_72838_d((Entity)playerHead);
        }
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }
}

