/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.overworld;

import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityMagickeShot;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class EntityMagicke
extends AoARangedMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 0.6f;

    public EntityMagicke(World world) {
        super(world, 0.6f, 2.1875f);
        this.mobProperties.add(Enums.MobProperties.MAGIC_IMMUNE);
    }

    public float func_70047_e() {
        return 1.6875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 15.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 4.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_MAGICKE_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_MAGICKE_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_MAGICKE_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundsRegister.MAGICKE_SHOOT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityMagicke;
    }

    @Override
    protected boolean isDaylightMob() {
        return true;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityMagickeShot(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 1.0f);
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, IBlockState blockHit, BlockPos pos, EnumFacing sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 1.0f);
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isMagicDamage(source, (Entity)this, damage);
    }

    @Override
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

