/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.overworld;

import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntitySphinx
extends AoAMeleeMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 1.0f;

    public EntitySphinx(World world) {
        super(world, 1.0f, 1.0f);
        this.mobProperties.add(Enums.MobProperties.GUN_IMMUNE);
    }

    public float func_70047_e() {
        return 0.875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 20.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 4.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_SPHINX_LIVING;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_SPHINX_DEATH;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_SPHINX_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entitySphinx;
    }

    @Override
    protected boolean isDaylightMob() {
        return true;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isGunDamage(source);
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }

    @Override
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

