/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.overworld.fullmoon;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityNightWatcher
extends AoAMeleeMob {
    public static final float entityWidth = 0.6f;

    public EntityNightWatcher(World world) {
        super(world, 0.6f, 2.7f);
    }

    public float func_70047_e() {
        return 2.5625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.3;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 45.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 5.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.295;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_NIGHT_WATCHER_LIVING;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_NIGHT_WATCHER_HIT;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_NIGHT_WATCHER_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityNightWatcher;
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean success = super.func_70097_a(source, amount);
        if (success && EntityUtil.isMeleeDamage(source)) {
            EntityUtil.safelyAddPotionEffect(source.func_76346_g(), MobEffects.field_76440_q, 65, 0, true, true);
        }
        return success;
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 95, 0, true, true));
        }
    }

    @Override
    @Nonnull
    protected Enums.CreatureEvents getEventRequirement() {
        return Enums.CreatureEvents.FULL_MOON;
    }
}

