/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.overworld.lunarinvasion;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.Enums;

public class EntityVertebron
extends AoAMeleeMob {
    public static final float entityWidth = 0.6f;

    public EntityVertebron(World world) {
        super(world, 0.6f, 2.1875f);
    }

    public float func_70047_e() {
        return 1.9375f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 45.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 5.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_VERTEBRON_LIVING;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_VERTEBRON_DEATH;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_VERTEBRON_HIT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityVertebron;
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (target instanceof EntityLivingBase) {
            double resist = 1.0;
            float velocity = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            IAttributeInstance attrib = ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c);
            if (attrib != null) {
                resist -= attrib.func_111126_e();
            }
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 50, 0, true, true));
            target.func_70024_g(this.field_70159_w * 2.1 * resist / (double)velocity, 0.1 * resist, this.field_70179_y * 2.1 * resist / (double)velocity);
            target.field_70133_I = true;
        }
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }

    @Override
    @Nonnull
    protected Enums.CreatureEvents getEventRequirement() {
        return Enums.CreatureEvents.LUNAR_INVASION;
    }
}

