/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.precasia;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityTerradon
extends AoAMeleeMob
implements SpecialPropertyEntity {
    private static final DataParameter<Boolean> INVULNERABLE = EntityDataManager.func_187226_a(EntityTerradon.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final float entityWidth = 1.25f;
    private int invulnCooldown = 0;

    public EntityTerradon(World world) {
        super(world, 1.25f, 1.875f);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
        this.setSlipperyMovement();
        this.func_70659_e(1.8f);
    }

    public float func_70047_e() {
        return 1.3125f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INVULNERABLE, (Object)false);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.8;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 105.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 10.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.329;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_TERRADON_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_TERRADON_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_TERRADON_HIT;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.VERY_HEAVY_STEP;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityTerradon;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isRangedDamage(source, (Entity)this, damage);
    }

    public boolean func_190530_aW() {
        return (Boolean)this.field_70180_af.func_187225_a(INVULNERABLE);
    }

    private void setInvulnerable(boolean invulnerable) {
        this.field_70180_af.func_187227_b(INVULNERABLE, (Object)invulnerable);
        if (invulnerable) {
            this.invulnCooldown = 200;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.invulnCooldown > 0) {
                --this.invulnCooldown;
            }
            if (this.invulnCooldown <= 0) {
                this.setInvulnerable(false);
            }
            if (!this.func_190530_aW() && this.field_70146_Z.nextInt(200) == 0) {
                this.setInvulnerable(true);
            }
        }
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

