/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.precasia;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityTortione
extends AoAMeleeMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 1.75f;

    public EntityTortione(World world) {
        super(world, 1.75f, 1.875f);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.GUN_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.MELEE_IMMUNE);
    }

    public float func_70047_e() {
        return 1.5625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.9;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 100.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 7.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.25;
    }

    @Override
    protected double getBaseArmour() {
        return 7.0;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_TORTIONE_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_TORTIONE_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_TORTIONE_HIT;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.ENTITY_GENERIC_HEAVY_STEP;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityTortione;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isGunDamage(source) || EntityUtil.isMeleeDamage(source) || EntityUtil.isRangedDamage(source, (Entity)this, 1.0f);
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

