/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.runandor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityRunicGuardianShot;
import net.tslat.aoa3.entity.projectiles.mob.EntityRunicGuardianShotHeavy;
import net.tslat.aoa3.entity.projectiles.mob.EntityRunicGuardianShotLight;
import net.tslat.aoa3.library.Enums;

public class EntityRunicGuardian
extends AoARangedMob {
    public static final float entityWidth = 0.6f;

    public EntityRunicGuardian(World world) {
        super(world, 0.6f, 2.0f);
    }

    public float func_70047_e() {
        return 1.75f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 109.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 13.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Override
    protected SoundEvent getStepSound() {
        return null;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityRunicGuardian;
    }

    @Override
    public void func_82196_d(@Nonnull EntityLivingBase target, float bowDamageFactor) {
        EntityRunicGuardianShotLight projectile1 = new EntityRunicGuardianShotLight(this, Enums.MobProjectileType.MAGIC);
        EntityRunicGuardianShot projectile2 = new EntityRunicGuardianShot(this, Enums.MobProjectileType.MAGIC);
        EntityRunicGuardianShotHeavy projectile3 = new EntityRunicGuardianShotHeavy(this, Enums.MobProjectileType.MAGIC);
        double distanceFactorX = target.field_70165_t - this.field_70165_t;
        double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - projectile1.field_70163_u;
        double distanceFactorZ = target.field_70161_v - this.field_70161_v;
        double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) + 0.2;
        if (this.getShootSound() != null) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getShootSound(), SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        projectile1.func_70186_c(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
        projectile2.func_70186_c(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
        projectile3.func_70186_c(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
        this.field_70170_p.func_72838_d((Entity)projectile1);
        this.field_70170_p.func_72838_d((Entity)projectile2);
        this.field_70170_p.func_72838_d((Entity)projectile3);
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundsRegister.WIZARD_BLAST_SHOOT;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return null;
    }
}

