/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.runandor;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntitySpectralShot;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntitySpectralWizard
extends AoARangedMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 0.5f;

    public EntitySpectralWizard(World world) {
        super(world, 0.5f, 2.1875f);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.GUN_IMMUNE);
    }

    public float func_70047_e() {
        return 1.9375f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 120.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 13.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.MOB_SPECTRAL_WIZARD_LIVING;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.MOB_SPECTRAL_WIZARD_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.MOB_SPECTRAL_WIZARD_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundsRegister.WIZARD_BLAST_SHOOT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entitySpectralWizard;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntitySpectralShot(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isGunDamage(source) || EntityUtil.isRangedDamage(source, (Entity)this, damage);
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

