/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.passive;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAAnimal;
import net.tslat.aoa3.entity.base.ai.mob.EntityAIFullPanic;

public class EntityShik
extends AoAAnimal {
    public static final float entityWidth = 0.375f;
    private static final DataParameter<Boolean> SCARED = EntityDataManager.func_187226_a(EntityShik.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DANCING = EntityDataManager.func_187226_a(EntityShik.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityShik dancePartner = null;

    public EntityShik(World world) {
        super(world, 0.375f, 0.4375f);
        this.field_175506_bl = BlockRegister.DEEPLANDS_STONE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SCARED, (Object)false);
        this.field_70180_af.func_187214_a(DANCING, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFullPanicHide(this, 100, 2.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIShikDance(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public float func_70047_e() {
        return 0.34375f;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 5.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2;
    }

    @Override
    protected double getBaseArmor() {
        return 4.0;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsRegister.ENTITY_SHIK_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.ENTITY_SHIK_DEATH;
    }

    @Override
    protected SoundEvent getStepSound() {
        return null;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityShik;
    }

    public boolean isScared() {
        return (Boolean)this.field_70180_af.func_187225_a(SCARED);
    }

    public boolean isDancing() {
        return (Boolean)this.field_70180_af.func_187225_a(DANCING);
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u < 120.0 && super.func_70601_bi();
    }

    @Override
    protected int getSpawnChanceFactor() {
        return 500;
    }

    protected boolean func_70692_ba() {
        return this.field_70173_aa > 400;
    }

    @Override
    protected boolean checkSpawningLightConditions() {
        return true;
    }

    public class EntityAIFullPanicHide
    extends EntityAIFullPanic {
        private BlockPos hidePos;

        public EntityAIFullPanicHide(EntityShik shik, int timeToPanic, double speed) {
            super((EntityCreature)shik, timeToPanic, speed);
        }

        @Override
        public boolean func_75250_a() {
            if (this.taskOwner.func_70681_au().nextFloat() <= 0.1f && !EntityShik.this.field_70170_p.func_175647_a(EntityLivingBase.class, this.taskOwner.func_174813_aQ().func_72314_b(5.0, 5.0, 5.0), entity -> entity != null && entity.getClass() != this.taskOwner.getClass()).isEmpty()) {
                return this.getRandomPosition();
            }
            return super.func_75250_a();
        }

        @Override
        public void func_75251_c() {
            this.taskOwner.field_70145_X = false;
            ((EntityShik)this.taskOwner).field_70180_af.func_187227_b(SCARED, (Object)false);
            super.func_75251_c();
        }

        @Override
        public void func_75249_e() {
            ((EntityShik)this.taskOwner).field_70180_af.func_187227_b(SCARED, (Object)true);
            super.func_75249_e();
        }

        @Override
        public void func_75246_d() {
            if (this.taskOwner.func_70681_au().nextFloat() < 0.1f) {
                int z;
                int x;
                BlockPos.MutableBlockPos checkPos;
                if (this.hidePos != null) {
                    if (this.hidePos.func_177957_d(this.taskOwner.field_70165_t, this.taskOwner.field_70163_u, this.taskOwner.field_70161_v) < 3.0) {
                        EntityShik.this.func_70106_y();
                        return;
                    }
                    if (this.taskOwner.func_70661_as().func_75500_f()) {
                        checkPos = new BlockPos.MutableBlockPos();
                        for (x = -1; x <= 1; ++x) {
                            for (z = -1; z <= 1; ++z) {
                                if (this.taskOwner.field_70170_p.func_180495_p((BlockPos)checkPos.func_189532_c(this.taskOwner.field_70165_t + (double)(-x), this.taskOwner.field_70163_u, this.taskOwner.field_70161_v + (double)(-z))).func_177230_c() != BlockRegister.DEEPLANDS_STONE) continue;
                                EntityShik.this.func_70106_y();
                                return;
                            }
                        }
                    }
                }
                if (this.hidePos == null && this.taskOwner.func_70681_au().nextFloat() < 0.1f) {
                    checkPos = new BlockPos.MutableBlockPos();
                    for (x = 0; x <= 3; ++x) {
                        for (z = 0; z <= 3; ++z) {
                            if (this.taskOwner.field_70170_p.func_180495_p((BlockPos)checkPos.func_189532_c(this.taskOwner.field_70165_t + (double)x, this.taskOwner.field_70163_u, this.taskOwner.field_70161_v + (double)z)).func_177230_c() == BlockRegister.DEEPLANDS_STONE) {
                                EntityShik.this.func_70661_as().func_75492_a((double)checkPos.func_177958_n() + 0.5, (double)checkPos.func_177956_o(), (double)checkPos.func_177952_p() + 0.5, this.speed);
                                ++this.panicTimer;
                                this.hidePos = checkPos.func_185334_h();
                                return;
                            }
                            if (this.taskOwner.field_70170_p.func_180495_p((BlockPos)checkPos.func_189532_c(this.taskOwner.field_70165_t + (double)(-x), this.taskOwner.field_70163_u, this.taskOwner.field_70161_v + (double)(-z))).func_177230_c() != BlockRegister.DEEPLANDS_STONE) continue;
                            this.taskOwner.func_70661_as().func_75492_a((double)checkPos.func_177958_n() + 0.5, (double)checkPos.func_177956_o(), (double)checkPos.func_177952_p() + 0.5, this.speed);
                            ++this.panicTimer;
                            this.hidePos = checkPos.func_185334_h();
                            return;
                        }
                    }
                }
            }
            super.func_75246_d();
        }
    }

    private class EntityAIShikDance
    extends EntityAIBase {
        private final EntityShik shik;
        private Vec3d startPos;
        private int danceTimer = 0;
        private int nextDanceTime = 0;
        private float danceAngleX;
        private float danceAngleZ;

        private EntityAIShikDance(EntityShik shik) {
            this.shik = shik;
            this.func_75248_a(6);
        }

        public boolean func_75250_a() {
            if (this.nextDanceTime + 100 >= this.shik.field_70173_aa) {
                return false;
            }
            if (this.shik.dancePartner != null && !((EntityShik)this.shik).dancePartner.field_70128_L) {
                return true;
            }
            if (EntityShik.this.field_70146_Z.nextFloat() <= 0.05f) {
                List dancePartners = EntityShik.this.field_70170_p.func_72872_a(EntityShik.class, EntityShik.this.func_174813_aQ().func_186662_g(0.5));
                for (EntityShik potentialPartner : dancePartners) {
                    if (potentialPartner == this.shik || potentialPartner.isScared() || potentialPartner.field_70128_L || potentialPartner.dancePartner != null || !potentialPartner.func_70685_l((Entity)this.shik) || !this.shik.func_70685_l((Entity)potentialPartner)) continue;
                    this.shik.dancePartner = potentialPartner;
                    potentialPartner.dancePartner = this.shik;
                    return true;
                }
            }
            return false;
        }

        public void func_75251_c() {
            this.shik.field_70180_af.func_187227_b(DANCING, (Object)false);
            this.startPos = null;
            this.danceTimer = 0;
            this.shik.func_70661_as().func_75499_g();
            this.nextDanceTime = EntityShik.this.field_70173_aa;
            this.shik.dancePartner = null;
        }

        public void func_75249_e() {
            EntityShik.this.func_70661_as().func_75499_g();
            this.startPos = EntityShik.this.func_174791_d();
            this.shik.field_70180_af.func_187227_b(DANCING, (Object)true);
            this.shik.func_70671_ap().func_75650_a(((EntityShik)this.shik).dancePartner.field_70165_t, ((EntityShik)this.shik).dancePartner.field_70163_u + (double)this.shik.dancePartner.func_70047_e(), ((EntityShik)this.shik).dancePartner.field_70161_v, (float)this.shik.dancePartner.func_184649_cE(), (float)this.shik.dancePartner.func_70646_bf());
            this.danceAngleX = MathHelper.func_76126_a((float)(this.shik.field_70177_z * (float)Math.PI / 180.0f)) * 2.0f;
            this.danceAngleZ = MathHelper.func_76134_b((float)(this.shik.field_70177_z * (float)Math.PI / 180.0f)) * 2.0f;
            EntityShik.this.func_70661_as().func_75492_a(this.startPos.field_72450_a + (double)(this.danceAngleX * 5.0f), this.startPos.field_72448_b, this.startPos.field_72449_c + (double)(this.danceAngleZ * 5.0f), 1.25);
        }

        public void func_75246_d() {
            ++this.danceTimer;
            this.shik.func_70671_ap().func_75650_a(((EntityShik)this.shik).dancePartner.field_70165_t, ((EntityShik)this.shik).dancePartner.field_70163_u + (double)this.shik.dancePartner.func_70047_e(), ((EntityShik)this.shik).dancePartner.field_70161_v, (float)this.shik.dancePartner.func_184649_cE(), (float)this.shik.dancePartner.func_70646_bf());
            this.shik.func_70101_b(this.shik.field_70759_as, this.shik.field_70125_A);
            if (this.danceTimer % 10 == 0 || EntityShik.this.func_70661_as().func_75500_f()) {
                this.danceAngleX *= -1.0f;
                this.danceAngleZ *= -1.0f;
                this.shik.func_70661_as().func_75499_g();
                this.shik.func_70661_as().func_75492_a(this.startPos.field_72450_a + (double)(this.danceAngleX * 5.0f), this.startPos.field_72448_b, this.startPos.field_72449_c + (double)(this.danceAngleZ * 5.0f), 1.25);
            }
        }

        public boolean func_75253_b() {
            return this.shik.dancePartner != null && this.startPos != null && !((EntityShik)this.shik).dancePartner.field_70128_L && this.danceTimer < 100;
        }
    }
}

