/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectiles.thrown;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.projectiles.HardProjectile;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.entity.projectiles.misc.EntityHellfireProjectile;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.utils.ModUtil;

public class EntityHellfire
extends BaseBullet
implements HardProjectile {
    private float explosionStrength = 1.5f;
    private EntityLivingBase shooter;
    private BaseGun gun;

    public EntityHellfire(World world) {
        super(world);
    }

    public EntityHellfire(EntityLivingBase shooter, BaseGun gun) {
        super(shooter, gun, 1.0f, 0, 1.5f);
        this.shooter = shooter;
        this.gun = gun;
    }

    public EntityHellfire(EntityLivingBase shooter, BaseGun gun, EnumHand hand, int maxAge, int piercingValue) {
        super(shooter, gun, hand, maxAge, 1.0f, piercingValue);
    }

    public EntityHellfire(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    public float func_70185_h() {
        return 0.075f;
    }

    public void setExplosionStrength(float strength) {
        this.explosionStrength = strength;
    }

    @Override
    public void doImpactEffect() {
        int count = 0;
        for (EntityMob e : this.field_70170_p.func_72872_a(EntityMob.class, this.func_174813_aQ().func_186662_g(7.0))) {
            this.field_70170_p.func_72838_d((Entity)new EntityHellfireProjectile(this, e.field_70165_t, e.field_70163_u, e.field_70161_v));
            e.func_70015_d(10);
            ++count;
        }
        if (this.shooter instanceof EntityPlayer) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.HELLFIRE_IMPACT, SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (count >= 20 && this.shooter instanceof EntityPlayerMP) {
                ModUtil.completeAdvancement((EntityPlayerMP)this.shooter, "overworld/heckfire", "20_target_hellfire");
            }
        }
    }
}

