/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.ParticleRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.misc.EntityHeartStone;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;
import net.tslat.aoa3.utils.skills.HunterUtil;
import net.tslat.aoa3.utils.skills.InnervationUtil;

public class EntityEvents {
    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent ev) {
        Entity killer;
        EntityLivingBase entity = ev.getEntityLiving();
        if (!entity.field_70170_p.field_72995_K && !(entity instanceof EntityPlayer) && (killer = ev.getSource().func_76346_g()) != null) {
            EntityPlayer killerPlayer = null;
            if (killer instanceof EntityTameable) {
                EntityLivingBase owner = ((EntityTameable)killer).func_70902_q();
                if (owner instanceof EntityPlayer) {
                    killerPlayer = (EntityPlayer)owner;
                }
            } else if (killer instanceof EntityPlayer) {
                killerPlayer = (EntityPlayer)killer;
            }
            if (killerPlayer != null) {
                float hunterXp;
                if (entity.func_110138_aP() > 1.0f && AdventOfAscension.rand.nextInt(8 * (entity instanceof IMob ? 1 : 3)) == 0 && InnervationUtil.canEntitySpawnHeartstone((Entity)entity)) {
                    EntityHeartStone heartStone = new EntityHeartStone(entity.field_70170_p, entity.func_180425_c());
                    entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundsRegister.HEART_STONE_SPAWN, SoundCategory.MASTER, 1.0f, 1.0f);
                    entity.field_70170_p.func_72838_d((Entity)heartStone);
                }
                if (entity.field_70170_p.field_73011_w.getDimension() == -1 && ev.getSource().field_76373_n.contains("explosion") && AdventOfAscension.rand.nextInt(4) == 0) {
                    entity.func_70099_a(new ItemStack((Item)ItemRegister.EXPLOSIVE_IDOL), 0.0f);
                }
                if ((hunterXp = HunterUtil.getHunterXp(entity)) > 0.0f) {
                    PlayerUtil.giveXpToPlayer(killerPlayer, Enums.Skills.HUNTER, hunterXp);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent ev) {
        if (ev.getEntityLiving().field_70170_p.field_72995_K && ConfigurationUtil.MainConfig.funOptions.partyDeaths && ev.getEntityLiving().field_70725_aQ >= 19) {
            AxisAlignedBB boundingBox = ev.getEntity().func_174813_aQ();
            double width = boundingBox.field_72336_d - boundingBox.field_72340_a;
            double depth = boundingBox.field_72334_f - boundingBox.field_72339_c;
            double height = boundingBox.field_72337_e - boundingBox.field_72338_b;
            Random rand = AdventOfAscension.rand;
            int i = 0;
            while ((double)i < 3.0 + 10.0 * width * depth * height) {
                ev.getEntityLiving().field_70170_p.func_175688_a(ParticleRegister.RAINBOW_FLUFFY, boundingBox.field_72340_a + rand.nextDouble() * width, boundingBox.field_72338_b + rand.nextDouble() * height, boundingBox.field_72339_c + rand.nextDouble() * depth, rand.nextGaussian() * 0.05, 0.0, rand.nextGaussian() * 0.05, new int[]{3, 30});
                ++i;
            }
        }
    }

    @SubscribeEvent
    public void onSpawnerSpawn(LivingSpawnEvent.SpecialSpawn ev) {
        if (ev.getSpawner() != null && HunterUtil.isHunterCreature(ev.getEntityLiving())) {
            ev.getEntityLiving().getEntityData().func_74757_a("IsHunterSpawnerMob", true);
        }
    }

    @SubscribeEvent
    public void onLivingTarget(LivingSetAttackTargetEvent ev) {
        EntityPlayer pl;
        int hunterLvl;
        if (!ev.getEntityLiving().field_70170_p.field_72995_K && ev.getEntityLiving() instanceof EntityLiving && (ev.getTarget() instanceof EntityPlayer || ev.getTarget() instanceof EntityTameable) && (hunterLvl = HunterUtil.getHunterLevel(ev.getEntityLiving())) > 1 && !ev.getEntityLiving().getEntityData().func_74767_n("IsHunterSpawnerMob") && (pl = PlayerUtil.getPlayerOrOwnerIfApplicable((Entity)ev.getTarget())) != null && PlayerUtil.getAdventPlayer(pl).stats().getLevel(Enums.Skills.HUNTER) < hunterLvl) {
            ((EntityLiving)ev.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent ev) {
        if (!HunterUtil.canAttackTarget(ev.getEntityLiving(), ev.getSource().func_76346_g(), true)) {
            ev.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityDestroyBlock(LivingDestroyBlockEvent ev) {
        if (ev.getEntity() instanceof EntityFireball) {
            if (ev.getState().func_177230_c().func_149638_a(ev.getEntity()) >= 1000000.0f) {
                ev.setCanceled(true);
            }
        } else if (ev.getState().func_185887_b(ev.getEntity().func_130014_f_(), ev.getPos()) < 0.0f) {
            ev.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent ev) {
        block3: {
            block4: {
                if (ev.getWorld().field_72995_K) break block3;
                if (!(ev.getEntity() instanceof EntityFishHook)) break block4;
                EntityFishHook hook = (EntityFishHook)ev.getEntity();
                EntityPlayerMP fisher = (EntityPlayerMP)hook.func_190619_l();
                if (fisher == null || !PlayerUtil.isWearingFullSet((EntityPlayer)fisher, Enums.ArmourSets.HAULING)) break block3;
                ItemStack stack = fisher.func_184586_b(EnumHand.MAIN_HAND);
                if (!(stack.func_77973_b() instanceof ItemFishingRod)) {
                    stack = fisher.func_184586_b(EnumHand.OFF_HAND);
                }
                if (!(stack.func_77973_b() instanceof ItemFishingRod)) break block3;
                hook.func_191516_a(Math.min(5, 2 + EnchantmentHelper.func_191528_c((ItemStack)stack)));
                break block3;
            }
            if (ev.getEntity() instanceof EntityWither && ev.getWorld().field_73011_w.getDimension() == -1) {
                for (EntityPlayer pl : ev.getWorld().func_72872_a(EntityPlayer.class, ev.getEntity().func_174813_aQ().func_186662_g(50.0))) {
                    if (!ItemUtil.findInventoryItem(pl, new ItemStack((Item)ItemRegister.BLANK_REALMSTONE), true, 1)) continue;
                    ItemUtil.givePlayerItemOrDrop(pl, new ItemStack((Item)ItemRegister.ABYSS_REALMSTONE));
                }
            }
        }
    }

    @SubscribeEvent
    public void onLootDrops(LivingDropsEvent ev) {
        if (!ev.getEntityLiving().field_70170_p.field_72995_K) {
            if (ev.getEntityLiving().field_70170_p.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.ancientCavern && ev.getEntityLiving().func_184222_aU()) {
                ev.getDrops().clear();
                ev.setCanceled(true);
                return;
            }
            if (ev.getEntityLiving() instanceof EntityWither) {
                EntityWither wither = (EntityWither)ev.getEntityLiving();
                LootTable lootTable = wither.field_70170_p.func_184146_ak().func_186521_a(LootSystemRegister.entityWither);
                LootContext.Builder builder = new LootContext.Builder((WorldServer)wither.field_70170_p).func_186472_a((Entity)wither).func_186473_a(ev.getSource());
                if (ev.isRecentlyHit() && wither.func_94060_bK() instanceof EntityPlayer) {
                    builder = builder.func_186470_a((EntityPlayer)wither.func_94060_bK()).func_186469_a(((EntityPlayer)wither.func_94060_bK()).func_184817_da());
                }
                for (ItemStack stack : lootTable.func_186462_a(wither.func_70681_au(), builder.func_186471_a())) {
                    wither.func_70099_a(stack, 0.0f);
                }
            }
            if (!(!HunterUtil.isHunterCreature(ev.getEntityLiving()) || ev.isRecentlyHit() && ev.getSource().func_76346_g() instanceof EntityPlayer && (((EntityPlayer)ev.getSource().func_76346_g()).field_71075_bZ.field_75098_d || HunterUtil.doesPlayerMeetHunterReq(ev.getEntityLiving(), (EntityPlayer)ev.getSource().func_76346_g())))) {
                ev.getDrops().clear();
                ev.setCanceled(true);
            }
        }
    }
}

