/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabBestiary;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabGuides;
import net.tslat.aoa3.client.gui.mainwindow.AdventMainGui;
import net.tslat.aoa3.hooks.crafttweaker.CraftTweakerCompat;
import net.tslat.aoa3.hooks.ic2.IC2Compat;
import net.tslat.aoa3.hooks.immersiveengineering.IECompat;
import net.tslat.aoa3.hooks.jer.JerHooks;
import net.tslat.aoa3.hooks.tconstruct.TinkersMaterialRegistry;
import net.tslat.aoa3.hooks.tconstruct.traits.Traits;
import net.tslat.aoa3.hooks.thaumcraft.ThaumcraftCompat;
import net.tslat.aoa3.hooks.thermalexpansion.ThermalExpansionCompat;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.skills.ButcheryUtil;
import net.tslat.aoa3.utils.skills.HunterUtil;
import net.tslat.aoa3.utils.skills.InnervationUtil;
import org.apache.logging.log4j.Level;

public final class ThirdPartyInteractions {
    static boolean tinkersConstructActive = false;
    static boolean jeiActive = false;
    static boolean jerActive = false;
    static boolean ic2Active = false;
    static boolean craftTweakerActive = false;
    static boolean immersiveEngineeringActive = false;
    static boolean thaumcraftActive = false;
    static boolean thermalExpansionActive = false;

    public static boolean isIc2Active() {
        return ic2Active;
    }

    public static boolean isTinkersConstructActive() {
        return tinkersConstructActive;
    }

    public static boolean isJEIActive() {
        return jeiActive;
    }

    public static boolean isJERActive() {
        return jerActive;
    }

    public static boolean isCraftTweakerActive() {
        return craftTweakerActive;
    }

    public static boolean isImmersiveEngineeringActive() {
        return immersiveEngineeringActive;
    }

    public static boolean isThaumcraftActive() {
        return thaumcraftActive;
    }

    public static boolean isThermalExpansionActive() {
        return thermalExpansionActive;
    }

    public static void preInit() {
        AdventOfAscension.logOptionalMessage("Checking for third-party integrations");
        if (Loader.isModLoaded((String)"tconstruct") && ConfigurationUtil.IntegrationsConfig.tinkersConstruct.enabled) {
            ThirdPartyInteractions.tinkersPreInit();
        }
        if (Loader.isModLoaded((String)"jeresources") && ConfigurationUtil.IntegrationsConfig.jer.enabled) {
            ThirdPartyInteractions.jeResourcesPreInit();
        }
        if (Loader.isModLoaded((String)"ic2") && ConfigurationUtil.IntegrationsConfig.ic2.enabled) {
            ThirdPartyInteractions.ic2PreInit();
        }
        if (Loader.isModLoaded((String)"crafttweaker") && ConfigurationUtil.IntegrationsConfig.craftTweaker.enabled) {
            ThirdPartyInteractions.craftTweakerPreInit();
        }
        if (Loader.isModLoaded((String)"jei") && ConfigurationUtil.IntegrationsConfig.jei.enabled) {
            jeiActive = true;
        }
        if (Loader.isModLoaded((String)"immersiveengineering") && ConfigurationUtil.IntegrationsConfig.immersiveEngineering.enabled) {
            immersiveEngineeringActive = true;
        }
        if (Loader.isModLoaded((String)"thaumcraft") && ConfigurationUtil.IntegrationsConfig.thaumcraft.enabled) {
            ThirdPartyInteractions.thaumcraftPreInit();
        }
        if (Loader.isModLoaded((String)"thermalexpansion") && ConfigurationUtil.IntegrationsConfig.thermalExpansion.enabled) {
            thermalExpansionActive = true;
        }
    }

    public static void init() {
        if (tinkersConstructActive) {
            TinkersMaterialRegistry.init();
            Traits.init();
        }
        if (jerActive) {
            JerHooks.init();
        }
        if (ic2Active) {
            IC2Compat.init();
        }
        if (immersiveEngineeringActive) {
            IECompat.init();
        }
        if (thermalExpansionActive) {
            ThermalExpansionCompat.init();
        }
    }

    private static void jeResourcesPreInit() {
        AdventOfAscension.logOptionalMessage("Found JEResources, integrating");
        jerActive = true;
    }

    private static void tinkersPreInit() {
        AdventOfAscension.logOptionalMessage("Found Tinkers Construct, integrating");
        if (ConfigurationUtil.IntegrationsConfig.tinkersConstruct.materials) {
            TinkersMaterialRegistry.preInit();
        }
        Traits.preInit();
        tinkersConstructActive = true;
    }

    private static void ic2PreInit() {
        AdventOfAscension.logOptionalMessage("Found IC2, integrating");
        IC2Compat.preInit();
        ic2Active = true;
    }

    private static void craftTweakerPreInit() {
        AdventOfAscension.logOptionalMessage("Found CraftTweaker, integrating");
        CraftTweakerCompat.preInit();
        craftTweakerActive = true;
    }

    private static void thaumcraftPreInit() {
        AdventOfAscension.logOptionalMessage("Found Thaumcraft, integrating");
        ThaumcraftCompat.preInit();
        thaumcraftActive = true;
    }

    public static void handleInterModComms(ImmutableList<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            switch (message.key) {
                case "mod_provides_guides": {
                    AdventGuiTabGuides.registerGuidesMod(message.getSender());
                    break;
                }
                case "mod_handles_bestiaries": {
                    if (!message.isFunctionMessage()) {
                        AdventOfAscension.logMessage(Level.WARN, "Received invalidly formatted bestiary handling IMC from mod: " + message.getSender() + ", skipping.");
                        return;
                    }
                    Optional bestiaryFunction = message.getFunctionValue(EntityLivingBase.class, Tuple.class);
                    if (!bestiaryFunction.isPresent()) {
                        AdventOfAscension.logMessage(Level.WARN, "Received invalidly formatted bestiary handling IMC from mod: " + message.getSender() + ", skipping.");
                        return;
                    }
                    AdventGuiTabBestiary.registerThirdPartyBestiaryHandler(message.getSender(), (Function)bestiaryFunction.get());
                    break;
                }
                case "mod_has_bestiary_entries": {
                    if (!message.isStringMessage()) {
                        AdventOfAscension.logMessage(Level.WARN, "Received invalidly formatted bestiary entry IMC from mod: " + message.getSender() + ", skipping.");
                        return;
                    }
                    AdventGuiTabBestiary.registerThirdPartyEntryHandler(message.getSender());
                    break;
                }
                case "add_advent_gui_theme": {
                    if (!message.isStringMessage()) {
                        AdventOfAscension.logMessage(Level.WARN, "Received invalidly formatted advent gui theme IMC from mod: " + message.getSender() + ", skipping.");
                        return;
                    }
                    Optional themeFunction = message.getFunctionValue(String.class, String.class);
                    if (!themeFunction.isPresent()) {
                        AdventOfAscension.logMessage(Level.WARN, "Received invalidly formatted advent gui theme IMC from mod: " + message.getSender() + ", skipping.");
                        return;
                    }
                    Function resourceGrabberFunction = (Function)themeFunction.get();
                    String name = (String)resourceGrabberFunction.apply("name");
                    ResourceLocation background = new ResourceLocation(message.getSender(), (String)resourceGrabberFunction.apply("background"));
                    ResourceLocation menuButtons = new ResourceLocation(message.getSender(), (String)resourceGrabberFunction.apply("buttons"));
                    ResourceLocation overlay = new ResourceLocation(message.getSender(), (String)resourceGrabberFunction.apply("overlay"));
                    AdventMainGui.addTheme(name, background, menuButtons, overlay);
                    break;
                }
                case "register_hunter_entity": {
                    if (!message.isStringMessage()) {
                        AdventOfAscension.logMessage(Level.WARN, "Received invalidly formatted hunter entity registration IMC from mod: " + message.getSender() + ", skipping.");
                        return;
                    }
                    HunterUtil.parseHunterCreatureRegistration(message.getStringValue());
                    break;
                }
                case "blacklist_heartstone_entity": {
                    if (!message.isStringMessage()) {
                        AdventOfAscension.logMessage(Level.WARN, "Received invalidly formatted heartstone blacklist entity registration IMC from mod: " + message.getSender() + ", skipping.");
                        return;
                    }
                    InnervationUtil.blacklistEntityIdFromHeartstones(new ResourceLocation(message.getStringValue()));
                    break;
                }
                case "blacklist_bloodlust_entity": {
                    if (!message.isStringMessage()) {
                        AdventOfAscension.logMessage(Level.WARN, "Received invalidly formatted bloodlust blacklist entity registration IMC from mod: " + message.getSender() + ", skipping.");
                        return;
                    }
                    ButcheryUtil.blacklistEntityIdFromBloodlusts(new ResourceLocation(message.getStringValue()));
                    break;
                }
            }
        }
    }
}

