/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks.crafttweaker.recipes;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.recipes.MCRecipeManager;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.tslat.aoa3.crafting.recipes.UpgradeKitRecipe;
import net.tslat.aoa3.utils.ItemUtil;
import scala.actors.threadpool.Arrays;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.aoa3.UpgradeKit")
public class CTUpgradeKit {
    @ZenMethod
    public static void addUpgradeKitRecipe(String id, IItemStack input, IItemStack upgradeKit, IItemStack output) {
        UpgradeKitRecipe recipe = new UpgradeKitRecipe("", CraftTweakerMC.getItemStack((IItemStack)input), CraftTweakerMC.getItemStack((IItemStack)upgradeKit), CraftTweakerMC.getItemStack((IItemStack)output));
        CraftTweakerAPI.apply((IAction)new AddUpgradeKitRecipe(recipe, id));
    }

    @ZenMethod
    public static void removeUpgradeKitRecipe(String resourcePath) {
        if (!resourcePath.contains(":")) {
            resourcePath = "aoa3:" + resourcePath;
        }
        CraftTweakerAPI.apply((IAction)new RemoveUpgradeKitRecipe(new ResourceLocation[]{new ResourceLocation(resourcePath)}));
    }

    @ZenMethod
    public static void removeUpgradeKitRecipes(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new RemoveUpgradeKitRecipe(CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    private static class AddUpgradeKitRecipe
    implements IAction {
        private final UpgradeKitRecipe recipe;
        private final String recipeId;

        private AddUpgradeKitRecipe(UpgradeKitRecipe recipe, String id) {
            this.recipe = recipe;
            this.recipeId = id;
        }

        public void apply() {
            ForgeRegistries.RECIPES.register(this.recipe.setRegistryName(new ResourceLocation("aoa3_ct", this.recipeId)));
        }

        public String describe() {
            return "Registering Upgrade Kit recipe for " + this.recipe.func_77571_b().func_82833_r() + ". Recipe ID: " + this.recipeId;
        }
    }

    private static class RemoveUpgradeKitRecipe
    extends MCRecipeManager.ActionBaseRemoveRecipes {
        @Nullable
        private final ResourceLocation[] recipeIds;
        @Nullable
        private final ItemStack outputStack;

        private RemoveUpgradeKitRecipe(ResourceLocation ... recipeIds) {
            this.recipeIds = recipeIds;
            this.outputStack = null;
        }

        private RemoveUpgradeKitRecipe(ItemStack outputStack) {
            this.outputStack = outputStack;
            this.recipeIds = null;
        }

        public void apply() {
            if (this.outputStack != null) {
                ArrayList<ResourceLocation> matchedRecipes = new ArrayList<ResourceLocation>();
                for (IRecipe recipe : ForgeRegistries.RECIPES.getValuesCollection()) {
                    if (!(recipe instanceof UpgradeKitRecipe) || !ItemUtil.areStacksFunctionallyEqual(this.outputStack, recipe.func_77571_b())) continue;
                    matchedRecipes.add(recipe.getRegistryName());
                }
                this.removeRecipes(matchedRecipes);
            } else {
                this.removeRecipes(Arrays.asList((Object[])this.recipeIds));
            }
        }

        public String describe() {
            if (this.outputStack != null) {
                return "Removing all Upgrade Kit recipes resulting in " + this.outputStack.func_82833_r() + " from the registry.";
            }
            return "Removing " + this.recipeIds.length + " Upgrade Kit recipes from the registry.";
        }
    }
}

