/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.hooks.ic2;

import ic2.api.item.IC2Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.Recipes;
import ic2.core.recipe.RecipeInputBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.WeaponRegister;
import net.tslat.aoa3.hooks.ic2.IC2CompatUtil;
import net.tslat.aoa3.item.misc.SimpleItem;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class IC2Compat {
    public static final IC2CompatUtil util = new IC2CompatUtil();
    private static ArrayList<IC2CompatMaterial> materials = new ArrayList();

    public static void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)new IC2Compat());
        if (ConfigurationUtil.IntegrationsConfig.ic2.materials) {
            materials.add(new IC2CompatMaterial("Baronyte", "baronyte", "baronyte_ore", "baronyte_block", "baronyte_ingot"));
            materials.add(new IC2CompatMaterial("Blazium", "blazium", "blazium_ore", "blazium_block", "blazium_ingot"));
            materials.add(new IC2CompatMaterial("Elecanium", "elecanium", "elecanium_ore", "elecanium_block", "elecanium_ingot"));
            materials.add(new IC2CompatMaterial("Emberstone", "emberstone", "emberstone_ore", "emberstone_block", "emberstone_ingot"));
            materials.add(new IC2CompatMaterial("Ghastly", "ghastly", "ghastly_ore", "ghastly_block", "ghastly_ingot"));
            materials.add(new IC2CompatMaterial("Ghoulish", "ghoulish", "ghoulish_ore", "ghoulish_block", "ghoulish_ingot"));
            materials.add(new IC2CompatMaterial("Limonite", "limonite", "limonite_ore", "limonite_block", "limonite_ingot"));
            materials.add(new IC2CompatMaterial("Lyon", "lyon", "lyon_ore", "lyon_block", "lyon_ingot"));
            materials.add(new IC2CompatMaterial("Mystite", "mystite", "mystite_ore", "mystite_block", "mystite_ingot"));
            materials.add(new IC2CompatMaterial("Rosite", "rosite", "rosite_ore", "rosite_block", "rosite_ingot"));
            materials.add(new IC2CompatMaterial("Shyrestone", "shyrestone", "shyrestone_ore", "shyrestone_block", "shyrestone_ingot"));
            materials.add(new IC2CompatMaterial("Varsium", "varsium", "varsium_ore", "varsium_block", "varsium_ingot"));
        }
    }

    public static void init() {
        for (IC2CompatMaterial material : materials) {
            material.addRecipes();
        }
        if (ConfigurationUtil.IntegrationsConfig.ic2.extractorRecipes) {
            Recipes.extractor.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack((Item)ItemRegister.UNPOWERED_RUNE, 16)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack((Item)ItemRegister.RUNIUM_CHUNK, 1)});
            Recipes.extractor.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack((Item)ItemRegister.CHARGED_RUNE, 16)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack((Item)ItemRegister.CHARGED_RUNIUM_CHUNK, 1)});
            Recipes.extractor.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack((Item)ItemRegister.RUSTED_IRON_INGOT)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack((Item)ItemRegister.SCRAP_METAL, 1)});
            Recipes.extractor.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack((Item)WeaponRegister.GRENADE, 2)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(Items.field_151016_H, 1)});
            Recipes.extractor.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack((Item)ItemRegister.CHESTBONE_FRAGMENT)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(Items.field_151100_aR, 5, 15)});
            Recipes.extractor.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack((Item)ItemRegister.LEGBONE_FRAGMENT)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(Items.field_151100_aR, 5, 15)});
            Recipes.extractor.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack((Item)ItemRegister.SKULLBONE_FRAGMENT)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(Items.field_151100_aR, 5, 15)});
            Recipes.extractor.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack((Item)ItemRegister.FOOTBONE_FRAGMENT)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(Items.field_151100_aR, 5, 15)});
            Recipes.extractor.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack((Item)ItemRegister.GOLD_COIN)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(Items.field_151043_k, 10)});
        }
        if (ConfigurationUtil.IntegrationsConfig.ic2.compressorRecipes) {
            Recipes.compressor.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack((Item)ItemRegister.CHITIN, 2)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack((Item)ItemRegister.ARMOUR_PLATING)});
            Recipes.compressor.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack((Item)ItemRegister.ICE_CRYSTAL, 4)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(Blocks.field_150403_cj, 8)});
        }
        materials = null;
    }

    public static IC2CompatUtil getCompatTool() {
        return util;
    }

    @SubscribeEvent
    public void registerIc2Items(RegistryEvent.Register<Item> ev) {
        for (IC2CompatMaterial material : materials) {
            material.register((IForgeRegistry<Item>)ev.getRegistry());
        }
    }

    @SubscribeEvent
    public void registerItemRenders(ModelRegistryEvent ev) {
        for (IC2CompatMaterial material : materials) {
            material.registerRenders();
        }
    }

    public static class IC2RecipeInputItemStack
    extends RecipeInputBase {
        public final ItemStack input;
        public final int amount;

        public IC2RecipeInputItemStack(ItemStack input) {
            this(input, 1);
        }

        public IC2RecipeInputItemStack(ItemStack input, int amount) {
            this.input = input;
            this.amount = amount;
        }

        public int getAmount() {
            return this.amount;
        }

        public boolean matches(ItemStack itemStack) {
            return ItemUtil.areStacksFunctionallyEqual(this.input, itemStack);
        }

        public List<ItemStack> getInputs() {
            return Arrays.asList(this.input);
        }

        public boolean equals(Object obj) {
            return obj != null && ((Object)((Object)this)).getClass() == obj.getClass() && this.matches(((IC2RecipeInputItemStack)((Object)obj)).input);
        }
    }

    private static class IC2CompatItem
    extends SimpleItem {
        private final String materialTypeName;
        private final String type;

        private IC2CompatItem(String type, String name, String registryName, String registryPrefix) {
            super(name, registryName);
            this.materialTypeName = "material." + registryPrefix + ".name";
            this.type = type;
        }

        public String func_77653_i(ItemStack stack) {
            return I18n.func_74838_a((String)("item.IC2" + this.type + ".name")).replace("%1$s", I18n.func_74838_a((String)this.materialTypeName));
        }
    }

    private static class IC2CompatMaterial {
        private final String registryPrefix;
        private final Supplier<Block> oreBlock;
        private final Supplier<Block> mineralBlock;
        private final Supplier<Item> ingot;
        private final Item crushedOre;
        private final Item purifiedCrushedOre;
        private final Item dust;
        private final Item tinyDust;
        private final Item plate;
        private final Item densePlate;

        private IC2CompatMaterial(String namePrefix, String registryPrefix, final String oreBlockId, final String mineralBlockId, final String ingotId) {
            this.registryPrefix = registryPrefix;
            this.mineralBlock = new Supplier<Block>(){
                private Block block = null;

                @Override
                public Block get() {
                    if (this.block != null) {
                        return this.block;
                    }
                    this.block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("aoa3", mineralBlockId));
                    return this.block;
                }
            };
            this.oreBlock = new Supplier<Block>(){
                private Block block = null;

                @Override
                public Block get() {
                    if (this.block != null) {
                        return this.block;
                    }
                    this.block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("aoa3", oreBlockId));
                    return this.block;
                }
            };
            this.ingot = new Supplier<Item>(){
                private Item ingot = null;

                @Override
                public Item get() {
                    if (this.ingot != null) {
                        return this.ingot;
                    }
                    this.ingot = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("aoa3", ingotId));
                    return this.ingot;
                }
            };
            this.crushedOre = new IC2CompatItem("CrushedOre", "Crushed" + namePrefix + "Ore", "crushed_" + registryPrefix + "_ore", registryPrefix);
            this.purifiedCrushedOre = new IC2CompatItem("PurifiedCrushedOre", "PurifiedCrushed" + namePrefix + "Ore", "purified_crushed_" + registryPrefix + "_ore", registryPrefix);
            this.dust = new IC2CompatItem("Dust", namePrefix + "Dust", registryPrefix + "_dust", registryPrefix);
            this.tinyDust = new IC2CompatItem("TinyDust", "Tiny" + namePrefix + "Dust", "tiny_" + registryPrefix + "_dust", registryPrefix);
            this.plate = new IC2CompatItem("Plate", namePrefix + "Plate", registryPrefix + "_plate", registryPrefix);
            this.densePlate = new IC2CompatItem("DensePlate", "Dense" + namePrefix + "Plate", "dense_" + registryPrefix + "_plate", registryPrefix);
        }

        private void addRecipes() {
            this.addMaceratorRecipes();
            this.addSmeltingRecipes();
            this.addMiscRecipes();
        }

        private void addMaceratorRecipes() {
            Recipes.macerator.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack(this.oreBlock.get())), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(this.crushedOre, 2)});
            Recipes.macerator.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack(this.ingot.get())), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(this.dust)});
            Recipes.macerator.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack(this.plate)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(this.tinyDust, 8)});
            Recipes.macerator.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack(this.densePlate)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(this.dust, 8)});
        }

        private void addSmeltingRecipes() {
            GameRegistry.addSmelting((Item)this.crushedOre, (ItemStack)new ItemStack(this.ingot.get()), (float)0.0f);
            GameRegistry.addSmelting((Item)this.purifiedCrushedOre, (ItemStack)new ItemStack(this.ingot.get()), (float)0.0f);
            GameRegistry.addSmelting((Item)this.dust, (ItemStack)new ItemStack(this.ingot.get()), (float)0.0f);
        }

        private void addMiscRecipes() {
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("aoa3", "ic2_" + this.registryPrefix + "_plate"), (ResourceLocation)new ResourceLocation(""), (ItemStack)new ItemStack(this.plate), (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)this.ingot.get()), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(IC2Items.getItemAPI().getItem("forge_hammer"), 1, Short.MAX_VALUE)})});
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("aoa3", "ic2_" + this.registryPrefix + "_dust"), (ResourceLocation)new ResourceLocation(""), (ItemStack)new ItemStack(this.dust), (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)this.tinyDust), Ingredient.func_193367_a((Item)this.tinyDust), Ingredient.func_193367_a((Item)this.tinyDust), Ingredient.func_193367_a((Item)this.tinyDust), Ingredient.func_193367_a((Item)this.tinyDust), Ingredient.func_193367_a((Item)this.tinyDust), Ingredient.func_193367_a((Item)this.tinyDust), Ingredient.func_193367_a((Item)this.tinyDust), Ingredient.func_193367_a((Item)this.tinyDust)});
            Recipes.compressor.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack(this.tinyDust), 9), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(this.dust)});
            Recipes.compressor.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack(this.plate), 9), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(this.densePlate)});
            Recipes.metalformerRolling.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack(this.ingot.get())), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(this.plate)});
            Recipes.blockcutter.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack(this.mineralBlock.get())), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(this.plate, 9)});
            Recipes.oreWashing.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack(this.crushedOre)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(this.purifiedCrushedOre), new ItemStack(this.tinyDust, 2), new ItemStack(IC2Items.getItemAPI().getItem("dust"), 1, 15)});
            Recipes.centrifuge.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack(this.crushedOre)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(this.tinyDust), new ItemStack(this.dust), new ItemStack(IC2Items.getItemAPI().getItem("dust"), 1, 15)});
            Recipes.centrifuge.addRecipe((IRecipeInput)new IC2RecipeInputItemStack(new ItemStack(this.purifiedCrushedOre)), new NBTTagCompound(), false, new ItemStack[]{new ItemStack(this.tinyDust), new ItemStack(this.dust)});
        }

        private void register(IForgeRegistry<Item> registry) {
            registry.registerAll((IForgeRegistryEntry[])new Item[]{this.crushedOre, this.purifiedCrushedOre, this.dust, this.tinyDust, this.plate, this.densePlate});
        }

        private void registerRenders() {
            ModelLoader.setCustomModelResourceLocation((Item)this.crushedOre, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("aoa3", "ic2/crushedore/" + this.crushedOre.getRegistryName().func_110623_a()), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)this.purifiedCrushedOre, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("aoa3", "ic2/purifiedcrushedore/" + this.purifiedCrushedOre.getRegistryName().func_110623_a()), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)this.dust, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("aoa3", "ic2/dust/" + this.dust.getRegistryName().func_110623_a()), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)this.tinyDust, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("aoa3", "ic2/tinydust/" + this.tinyDust.getRegistryName().func_110623_a()), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)this.plate, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("aoa3", "ic2/plate/" + this.plate.getRegistryName().func_110623_a()), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)this.densePlate, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("aoa3", "ic2/denseplate/" + this.densePlate.getRegistryName().func_110623_a()), "inventory"));
        }
    }
}

